/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.view;

import edu.colorado.phet.common.phetcommon.resources.PhetResources;
import edu.colorado.phet.common.phetcommon.util.ConstantPowerOfTenNumberFormat;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.PieChartNode;
import edu.colorado.phet.common.piccolophet.nodes.ResizeArrowNode;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsConstants;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.common.NucleusDisplayInfo;
import edu.colorado.phet.nuclearphysics.common.NucleusType;
import edu.colorado.phet.nuclearphysics.common.model.AtomicNucleus;
import edu.colorado.phet.nuclearphysics.model.HalfLifeInfo;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

public class NuclearDecayProportionChart
extends PNode {
    private static final Color BORDER_COLOR = Color.DARK_GRAY;
    private static final Stroke BORDER_STROKE = new BasicStroke(6.0f);
    private double _timeSpan;
    private double _halfLife;
    private NucleusDisplayInfo _preDecayNucleusDisplayInfo = NucleusDisplayInfo.DEFAULT_DISPLAY_INFO;
    private NucleusDisplayInfo _postDecayNucleusDisplayInfo = NucleusDisplayInfo.DEFAULT_DISPLAY_INFO;
    private boolean _pieChartEnabled;
    private boolean _showPostDecayCurve;
    private boolean _movablePercentIndicatorEnabled;
    private PPath _borderNode;
    private ProportionsPieChartNode _pieChart;
    private GraphNode _graph;
    private MovablePercentIndicator _movablePercentIndicator;
    private CarbonOptionsPanel _carbonOptionsPanel;
    private PSwing _carbonOptionsPanelPSwing;
    ArrayList<Point2D> _decayEvents = new ArrayList();
    private PNode _nonPickableChartNode;
    private PNode _pickableChartNode;
    Rectangle2D _boundingRect = new Rectangle2D.Double();
    Rectangle2D _usableAreaRect = new Rectangle2D.Double();
    boolean _squareMode = false;
    boolean _showCarbonOptions = false;
    boolean _yAxisLabeledWithRatio = false;

    public NuclearDecayProportionChart(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this._pieChartEnabled = bl;
        this._movablePercentIndicatorEnabled = bl2;
        this._showPostDecayCurve = bl3;
        this._timeSpan = 1000.0;
        this._halfLife = 300.0;
        this._nonPickableChartNode = new PNode();
        this._nonPickableChartNode.setPickable(false);
        this._nonPickableChartNode.setChildrenPickable(false);
        this.addChild(this._nonPickableChartNode);
        this._pickableChartNode = new PNode();
        this._pickableChartNode.setPickable(true);
        this._pickableChartNode.setChildrenPickable(true);
        this.addChild(this._pickableChartNode);
        this._borderNode = new PPath();
        this._borderNode.setStroke(BORDER_STROKE);
        this._borderNode.setStrokePaint(BORDER_COLOR);
        this._borderNode.setPaint(NuclearPhysicsConstants.CHART_BACKGROUND_COLOR);
        this._nonPickableChartNode.addChild(this._borderNode);
        this._graph = new GraphNode(this, bl4);
        this._nonPickableChartNode.addChild(this._graph);
        if (this._pieChartEnabled) {
            this._pieChart = new ProportionsPieChartNode(this);
            this._nonPickableChartNode.addChild(this._pieChart);
        }
        this._carbonOptionsPanel = new CarbonOptionsPanel(this);
        this._carbonOptionsPanelPSwing = new PSwing(this._carbonOptionsPanel);
        this._pickableChartNode.addChild(this._carbonOptionsPanelPSwing);
        if (this._movablePercentIndicatorEnabled) {
            this._movablePercentIndicator = new MovablePercentIndicator(this);
            this._pickableChartNode.addChild(this._movablePercentIndicator);
        }
    }

    public void setTimeParameters(double d, double d2) {
        this._timeSpan = d;
        this._halfLife = d2;
        this.updateLayout();
    }

    public void setDisplayInfoForNucleusType(NucleusType nucleusType) {
        this._preDecayNucleusDisplayInfo = NucleusDisplayInfo.getDisplayInfoForNucleusType(nucleusType);
        this._postDecayNucleusDisplayInfo = NucleusDisplayInfo.getDisplayInfoForNucleusType(AtomicNucleus.getPostDecayNuclei(nucleusType).get(0));
        this.clear();
        this.updateLayout();
    }

    public void setSquareModeEnabled(boolean bl) {
        this._squareMode = bl;
    }

    public void setLineModeEnabled(boolean bl) {
        this._graph.setLineGraph(bl);
    }

    public void setShowCarbonOptions(boolean bl) {
        if (this._showCarbonOptions != bl) {
            this._showCarbonOptions = bl;
            this._graph.updateYAxisGridLineLabels();
            this.updateLayout();
        }
    }

    protected void setYAxisLabeledWithRatio(boolean bl) {
        if (this._yAxisLabeledWithRatio != bl) {
            this._yAxisLabeledWithRatio = bl;
            this._graph.updateYAxisGridLineLabels();
            this.updateLayout();
        }
    }

    public void updateMarkerText() {
        if (this._movablePercentIndicatorEnabled) {
            this._movablePercentIndicator.updateReadoutText();
        }
    }

    protected Point2D getGraphOriginPos() {
        Point2D point2D = this._graph.getOriginOffset();
        return new Point2D.Double(point2D.getX() + this._graph.getOffset().getX(), point2D.getY() + this._graph.getOffset().getY());
    }

    protected double getGraphMaxX() {
        return this._graph.getFullBoundsReference().getMaxX();
    }

    protected double getDataValueForXPixelPos(double d) {
        return this._graph.getDataValueForXPixelPos(d - this._graph.getOffset().getX());
    }

    protected double getTimeValueForXPixelPos(double d) {
        return this._graph.getTimeValueForXPixelPos(d - this._graph.getOffset().getX());
    }

    private void updateBounds(Rectangle2D rectangle2D) {
        if (rectangle2D.getHeight() <= 0.0 || rectangle2D.getWidth() <= 0.0) {
            return;
        }
        this._boundingRect = rectangle2D;
        if (rectangle2D.getX() != 0.0 || rectangle2D.getY() != 0.0) {
            System.err.println(this.getClass().getName() + ": Warning - Got a non-zero offset for chart bounds.");
        }
        this._usableAreaRect.setRect(rectangle2D.getX() + 6.0, rectangle2D.getY() + 6.0, rectangle2D.getWidth() - 12.0, rectangle2D.getHeight() - 12.0);
        this.updateLayout();
    }

    private void updateLayout() {
        if (this._usableAreaRect.getWidth() <= 0.0 || this._usableAreaRect.getHeight() <= 0.0) {
            return;
        }
        this._borderNode.setPathTo(new RoundRectangle2D.Double(this._boundingRect.getX(), this._boundingRect.getY(), this._boundingRect.getWidth(), this._boundingRect.getHeight(), 20.0, 20.0));
        double d = 0.0;
        if (this._pieChartEnabled) {
            this._pieChart.scale(1.0);
            this._pieChart.scale(this._usableAreaRect.getWidth() * 0.1 / this._pieChart.getFullBoundsReference().getWidth());
            this._pieChart.setOffset(12.0, this._usableAreaRect.getCenterY() - this._pieChart.getFullBoundsReference().getHeight() / 2.0);
            d = this._pieChart.getFullBoundsReference().getMaxX();
        }
        if (!this._movablePercentIndicatorEnabled) {
            this._graph.update((this._usableAreaRect.getMaxX() - d) * 0.98, this._usableAreaRect.getHeight() * 0.95);
            this._graph.update((this._usableAreaRect.getMaxX() - d) * 0.95, this._usableAreaRect.getHeight() * 0.8275);
            this._graph.setOffset(d + 5.0, this._usableAreaRect.getMaxY() - this._graph.getFullBoundsReference().height);
        } else {
            this._graph.update((this._usableAreaRect.getMaxX() - d) * 0.95, this._usableAreaRect.getHeight() * 0.77);
            this._graph.setOffset(d + 5.0, this._usableAreaRect.getMaxY() - this._graph.getFullBoundsReference().height);
        }
        if (this._showCarbonOptions) {
            this._carbonOptionsPanelPSwing.setVisible(true);
            this._carbonOptionsPanelPSwing.setScale(1.0);
            this._carbonOptionsPanelPSwing.scale(this._usableAreaRect.getHeight() * 0.23 / this._carbonOptionsPanelPSwing.getFullBoundsReference().getHeight());
            this._carbonOptionsPanelPSwing.setOffset(d + 0.12 * this._usableAreaRect.getWidth(), this._usableAreaRect.getMinY());
        } else {
            this._carbonOptionsPanelPSwing.setVisible(false);
        }
        if (this._movablePercentIndicatorEnabled) {
            this._movablePercentIndicator.updateLayout((int)Math.round(this._usableAreaRect.getWidth() * 0.22), (int)Math.round(this._usableAreaRect.getHeight() * 0.23 * 0.85), (int)Math.round(this._graph.getFullBoundsReference().getY()), (int)Math.round(this._graph.getOriginOffset().getY() + this._graph.getOffset().getY()));
        }
    }

    public void componentResized(Rectangle2D rectangle2D) {
        this.updateBounds(rectangle2D);
    }

    public void clear() {
        this._decayEvents.clear();
        this._graph.clearData();
        if (this._pieChart != null) {
            this._pieChart.reset();
        }
    }

    public void addDataPoint(double d, int n, int n2) {
        if (this._pieChart != null) {
            this._pieChart.setAmounts(n, n2);
        }
        if (this._squareMode && this._decayEvents.size() > 0) {
            Point2D point2D = this._decayEvents.get(this._decayEvents.size() - 1);
            Point2D.Double double_ = new Point2D.Double(d, point2D.getY());
            this._graph.graphDecayEvent(double_);
        }
        double d2 = n == 0 ? 0.0 : 100.0 * (double)n / (double)(n2 + n);
        Point2D.Double double_ = new Point2D.Double(d, d2);
        this._decayEvents.add(double_);
        this._graph.graphDecayEvent(double_);
    }

    public void addDataPoint(double d, double d2) {
        assert (!this._pieChartEnabled);
        assert (d2 >= 0.0);
        assert (d2 <= 100.0);
        Point2D.Double double_ = new Point2D.Double(d, d2);
        this._decayEvents.add(double_);
        this._graph.graphDecayEvent(double_);
    }

    private static class CarbonOptionsPanel
    extends VerticalLayoutPanel {
        private static final Font LABEL_FONT = new PhetFont(16, true);
        private NuclearDecayProportionChart _chart;
        private JRadioButton _percentC14RadioButton;
        private JRadioButton _c14C12RatioRadioButton;

        public CarbonOptionsPanel(NuclearDecayProportionChart nuclearDecayProportionChart) {
            this._chart = nuclearDecayProportionChart;
            this.setBackground(NuclearPhysicsConstants.CHART_BACKGROUND_COLOR);
            this._percentC14RadioButton = new JRadioButton(NuclearPhysicsStrings.DECAY_PROPORTIONS_PERCENT_C14);
            this._percentC14RadioButton.setFont(LABEL_FONT);
            this._percentC14RadioButton.setBackground(this.getBackground());
            this.add(this._percentC14RadioButton);
            this._c14C12RatioRadioButton = new JRadioButton(NuclearPhysicsStrings.DECAY_PROPORTIONS_C14_C12_RATIO);
            this._c14C12RatioRadioButton.setFont(LABEL_FONT);
            this._c14C12RatioRadioButton.setBackground(this.getBackground());
            this.add(this._c14C12RatioRadioButton);
            this._percentC14RadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CarbonOptionsPanel.this._chart.setYAxisLabeledWithRatio(false);
                }
            });
            this._c14C12RatioRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CarbonOptionsPanel.this._chart.setYAxisLabeledWithRatio(true);
                }
            });
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this._percentC14RadioButton);
            buttonGroup.add(this._c14C12RatioRadioButton);
            this.reset();
        }

        public void reset() {
            this._percentC14RadioButton.setSelected(true);
        }
    }

    private static class GraphNode
    extends PNode {
        private static final Stroke THICK_AXIS_STROKE = new BasicStroke(2.5f);
        private static final Stroke THIN_AXIS_STROKE = new BasicStroke(0.75f);
        private static final Color AXES_LINE_COLOR = Color.BLACK;
        private static final Stroke TICK_MARK_STROKE = new BasicStroke(2.0f);
        private static final Color TICK_MARK_COLOR = AXES_LINE_COLOR;
        private static final Font BOLD_LABEL_FONT = new PhetFont(1, 18);
        private static final Stroke HALF_LIFE_LINE_STROKE = new BasicStroke(2.0f, 0, 2, 0.0f, new float[]{3.0f, 3.0f}, 0.0f);
        private static final Color HALF_LIFE_LINE_COLOR = new Color(238, 0, 0);
        private static final Color Y_AXIS_GRID_LINES_COLOR = Color.LIGHT_GRAY;
        private static final Stroke Y_AXIS_GRID_LINES_STROKE = THIN_AXIS_STROKE;
        private static final NumberFormat NUMBER_FORMAT = NumberFormat.getNumberInstance(PhetResources.readLocale());
        private static final ConstantPowerOfTenNumberFormat RATIO_FORMATTER = new ConstantPowerOfTenNumberFormat("0.0", -12, 80);
        private NuclearDecayProportionChart _chart;
        private PPath _sizingRect;
        private ArrayList<PPath> _halfLifeLines = new ArrayList();
        private ArrayList<PText> _halfLifeLineLabels = new ArrayList();
        private final PPath _lowerXAxisOfGraph;
        private final PText _lowerXAxisLabel;
        private final PPath _upperXAxisOfGraph;
        private final PPath _leftYAxisOfGraph;
        private final PPath _rightYAxisOfGraph;
        private ArrayList<PhetPPath> _xAxisTickMarks = new ArrayList();
        private ArrayList<PText> _xAxisTickMarkLabels = new ArrayList();
        private ArrayList<PPath> _yAxisGridLines = new ArrayList();
        private ArrayList<HTMLNode> _yAxisGridLineLabels = new ArrayList();
        private final HTMLNode _yAxisLabel;
        private final PText _upperXAxisLabel;
        private final PNode _pickableGraphLayer;
        private final PNode _nonPickableGraphLayer;
        private final PNode _dataPresentationLayer;
        private PPath _preDecayProportionCurve;
        private PPath _postDecayProportionCurve;
        private Stroke _dataCurveStroke = new BasicStroke();
        private Ellipse2D _dataPointShape = new Ellipse2D.Double();
        private Point2D _previousDecayEvent;
        double _msToPixelsFactor = 1.0;
        private final Rectangle2D _graphRect = new Rectangle2D.Double();
        private double _labelScalingFactor;
        private boolean _lineGraph;

        public GraphNode(NuclearDecayProportionChart nuclearDecayProportionChart, boolean bl) {
            PNode pNode;
            int n;
            this._chart = nuclearDecayProportionChart;
            this._lineGraph = bl;
            this._nonPickableGraphLayer = new PNode();
            this._nonPickableGraphLayer.setPickable(false);
            this._nonPickableGraphLayer.setChildrenPickable(false);
            this.addChild(this._nonPickableGraphLayer);
            this._dataPresentationLayer = new PNode();
            this._dataPresentationLayer.setPickable(false);
            this._dataPresentationLayer.setChildrenPickable(false);
            this.addChild(this._dataPresentationLayer);
            this._pickableGraphLayer = new PNode();
            this._pickableGraphLayer.setPickable(true);
            this._pickableGraphLayer.setChildrenPickable(true);
            this.addChild(this._pickableGraphLayer);
            this._lowerXAxisOfGraph = new PPath();
            this._lowerXAxisOfGraph.setStroke(THICK_AXIS_STROKE);
            this._lowerXAxisOfGraph.setStrokePaint(AXES_LINE_COLOR);
            this._lowerXAxisOfGraph.setPaint(AXES_LINE_COLOR);
            this._nonPickableGraphLayer.addChild(this._lowerXAxisOfGraph);
            this._upperXAxisOfGraph = new PPath();
            this._upperXAxisOfGraph.setStroke(THIN_AXIS_STROKE);
            this._upperXAxisOfGraph.setStrokePaint(AXES_LINE_COLOR);
            this._upperXAxisOfGraph.setPaint(AXES_LINE_COLOR);
            this._nonPickableGraphLayer.addChild(this._upperXAxisOfGraph);
            this._lowerXAxisLabel = new PText();
            this._lowerXAxisLabel.setFont(BOLD_LABEL_FONT);
            this._nonPickableGraphLayer.addChild(this._lowerXAxisLabel);
            this._leftYAxisOfGraph = new PPath();
            this._leftYAxisOfGraph.setStroke(THIN_AXIS_STROKE);
            this._leftYAxisOfGraph.setStrokePaint(AXES_LINE_COLOR);
            this._leftYAxisOfGraph.setPaint(AXES_LINE_COLOR);
            this._nonPickableGraphLayer.addChild(this._leftYAxisOfGraph);
            this._rightYAxisOfGraph = new PPath();
            this._rightYAxisOfGraph.setStroke(THIN_AXIS_STROKE);
            this._rightYAxisOfGraph.setStrokePaint(AXES_LINE_COLOR);
            this._rightYAxisOfGraph.setPaint(AXES_LINE_COLOR);
            this._nonPickableGraphLayer.addChild(this._rightYAxisOfGraph);
            for (n = 0; n < 4; ++n) {
                pNode = new HTMLNode();
                this._yAxisGridLineLabels.add((HTMLNode)pNode);
                this._nonPickableGraphLayer.addChild(pNode);
            }
            this.updateYAxisGridLineLabels();
            this._yAxisLabel = new HTMLNode();
            this._yAxisLabel.rotate(-1.5707963267948966);
            this._nonPickableGraphLayer.addChild(this._yAxisLabel);
            for (n = 0; n < 3; ++n) {
                pNode = new PhetPPath(Y_AXIS_GRID_LINES_COLOR, Y_AXIS_GRID_LINES_STROKE, Y_AXIS_GRID_LINES_COLOR);
                this._nonPickableGraphLayer.addChild(pNode);
                this._yAxisGridLines.add((PPath)pNode);
            }
            this._upperXAxisLabel = new PText(NuclearPhysicsStrings.HALF_LIVES_LABEL);
            this._upperXAxisLabel.setFont(BOLD_LABEL_FONT);
            this._nonPickableGraphLayer.addChild(this._upperXAxisLabel);
            this._sizingRect = new PPath();
            this._sizingRect.setStroke(THICK_AXIS_STROKE);
            this._sizingRect.setStrokePaint(Color.red);
            this._sizingRect.setPickable(false);
            this.addChild(this._sizingRect);
            this._sizingRect.setVisible(false);
        }

        public void setLineGraph(boolean bl) {
            this._lineGraph = bl;
        }

        public void updateYAxisGridLineLabels() {
            if (this._chart._showCarbonOptions && this._chart._yAxisLabeledWithRatio) {
                double d = 1.3E-12;
                for (int i = 0; i < 4; ++i) {
                    this._yAxisGridLineLabels.get(i).setHTML(RATIO_FORMATTER.format((double)(i + 1) * d / 4.0));
                }
            } else {
                this._yAxisGridLineLabels.get(0).setHTML(NuclearPhysicsStrings.TWENTY_FIVE_PER_CENT);
                this._yAxisGridLineLabels.get(1).setHTML(NuclearPhysicsStrings.FIFTY_PER_CENT);
                this._yAxisGridLineLabels.get(2).setHTML(NuclearPhysicsStrings.SEVENTY_FIVE_PER_CENT);
                this._yAxisGridLineLabels.get(3).setHTML(NuclearPhysicsStrings.ONE_HUNDRED_PER_CENT);
            }
        }

        public void update(double d, double d2) {
            double d3 = d2 * 0.12;
            PText pText = new PText("Dummy");
            pText.setFont(BOLD_LABEL_FONT);
            this._labelScalingFactor = d3 / pText.getFullBoundsReference().height;
            this._sizingRect.setPathTo(new Rectangle2D.Double(0.0, 0.0, d, d2));
            this._dataCurveStroke = new BasicStroke((float)(d2 * (double)0.02f), 1, 1);
            double d4 = d2 * (double)0.02f;
            this._dataPointShape.setFrame(-d4 / 2.0, -d4 / 2.0, d4, d4);
            if (this._chart._yAxisLabeledWithRatio && this._chart._showCarbonOptions) {
                this._yAxisLabel.setHTML(NuclearPhysicsStrings.DECAY_PROPORTIONS_Y_AXIS_LABEL_RATIO_C14_TO_C12);
            } else {
                this._yAxisLabel.setHTML(NuclearPhysicsStrings.DECAY_PROPORTIONS_Y_AXIS_LABEL_PERCENT_PRESENT);
            }
            this._yAxisLabel.setScale(1.0);
            double d5 = d2 * 0.8 / this._yAxisLabel.getFullBoundsReference().getHeight();
            this._yAxisLabel.setScale(d5);
            this._yAxisLabel.setOffset(0.0, d2 / 2.0 - this._yAxisLabel.getFullBoundsReference().width / 2.0);
            double d6 = 0.0;
            for (HTMLNode hTMLNode : this._yAxisGridLineLabels) {
                hTMLNode.setScale(1.0);
                hTMLNode.setScale(this._labelScalingFactor);
                d6 = Math.max(hTMLNode.getFullBoundsReference().width, d6);
            }
            this._graphRect.setRect(this._yAxisLabel.getFullBoundsReference().width + (d6 *= 1.2), d3 * 1.8, d - this._yAxisLabel.getFullBoundsReference().getWidth() - d6, d2 - 3.6 * d3);
            this._yAxisLabel.setOffset(this._yAxisLabel.getOffset().getX(), this._graphRect.getCenterY() + this._yAxisLabel.getFullBoundsReference().height / 2.0);
            assert (this._yAxisGridLineLabels.size() == this._yAxisGridLines.size() + 1);
            double d7 = this._graphRect.getHeight() / (double)this._yAxisGridLineLabels.size();
            for (int i = 0; i < this._yAxisGridLineLabels.size(); ++i) {
                HTMLNode hTMLNode = this._yAxisGridLineLabels.get(i);
                hTMLNode.setOffset(this._yAxisLabel.getFullBoundsReference().getWidth() + d6 * 0.9 - hTMLNode.getFullBoundsReference().width, this._graphRect.getMaxY() - (double)(i + 1) * d7 - hTMLNode.getFullBoundsReference().height / 2.0);
                if (i >= this._yAxisGridLines.size()) continue;
                PPath pPath = this._yAxisGridLines.get(i);
                pPath.setPathTo(new Line2D.Double(0.0, 0.0, this._graphRect.getWidth(), 0.0));
                pPath.setOffset(this._graphRect.getX(), this._graphRect.getMaxY() - (double)(i + 1) * d7 - pPath.getFullBoundsReference().height / 2.0);
            }
            this._msToPixelsFactor = this._graphRect.getWidth() / this._chart._timeSpan;
            this._lowerXAxisOfGraph.setPathTo(new Line2D.Double(this._graphRect.getX(), this._graphRect.getMaxY(), this._graphRect.getMaxX(), this._graphRect.getMaxY()));
            this._upperXAxisOfGraph.setPathTo(new Line2D.Double(this._graphRect.getX(), this._graphRect.getY(), this._graphRect.getMaxX(), this._graphRect.getY()));
            this._leftYAxisOfGraph.setPathTo(new Line2D.Double(this._graphRect.getX(), this._graphRect.getY(), this._graphRect.getX(), this._graphRect.getMaxY()));
            this._rightYAxisOfGraph.setPathTo(new Line2D.Double(this._graphRect.getMaxX(), this._graphRect.getY(), this._graphRect.getMaxX(), this._graphRect.getMaxY()));
            this.updateXAxisTickMarksAndLabels();
            this.updateHalfLifeLines();
            this.updateDecayCurves();
        }

        public void clearData() {
            this._dataPresentationLayer.removeAllChildren();
            this._preDecayProportionCurve = null;
            this._postDecayProportionCurve = null;
        }

        public Point2D getOriginOffset() {
            return new Point2D.Double(this._graphRect.getX(), this._graphRect.getMaxY());
        }

        public double getDataValueForXPixelPos(double d) {
            double d2 = 0.0;
            double d3 = (d - this._graphRect.getX()) / this._msToPixelsFactor;
            double d4 = Double.POSITIVE_INFINITY;
            if (this._chart._decayEvents.size() == 0) {
                d2 = 0.0;
            } else if (d3 < this._chart._decayEvents.get(0).getX()) {
                d2 = this._chart._decayEvents.get(0).getY();
            } else {
                Point2D point2D = null;
                Point2D point2D2 = null;
                for (int i = 0; i < this._chart._decayEvents.size(); ++i) {
                    point2D = this._chart._decayEvents.get(i);
                    if (i == this._chart._decayEvents.size() - 1) {
                        point2D2 = point2D;
                        continue;
                    }
                    point2D2 = this._chart._decayEvents.get(i + 1);
                    if (d3 >= point2D.getX() && d3 < point2D2.getX()) break;
                }
                d2 = d3 - point2D.getX() <= point2D2.getX() - d3 ? point2D.getY() : point2D2.getY();
            }
            return d2;
        }

        public double getTimeValueForXPixelPos(double d) {
            double d2 = 0.0;
            d2 = d < this._graphRect.getX() ? 0.0 : (d > this._graphRect.getMaxX() ? this._graphRect.getWidth() / this._msToPixelsFactor : (d - this._graphRect.getX()) / this._msToPixelsFactor);
            return d2;
        }

        private void updateHalfLifeLines() {
            int n;
            PNode pNode;
            int n2 = (int)Math.floor(this._chart._timeSpan / this._chart._halfLife);
            if (n2 > 10) {
                System.err.println(this.getClass().getName() + " - Warning: Too many half life lines, ignoring request to draw them.");
                return;
            }
            if (n2 != this._halfLifeLines.size()) {
                Iterator<PNode> iterator = this._halfLifeLines.iterator();
                while (iterator.hasNext()) {
                    pNode = iterator.next();
                    this._nonPickableGraphLayer.removeChild(pNode);
                    iterator.remove();
                }
                iterator = this._halfLifeLineLabels.iterator();
                while (iterator.hasNext()) {
                    pNode = iterator.next();
                    this._nonPickableGraphLayer.removeChild(pNode);
                    iterator.remove();
                }
                for (n = 0; n < n2; ++n) {
                    pNode = new PPath();
                    ((PPath)pNode).setStroke(HALF_LIFE_LINE_STROKE);
                    ((PPath)pNode).setStrokePaint(HALF_LIFE_LINE_COLOR);
                    this._nonPickableGraphLayer.addChild(pNode);
                    this._halfLifeLines.add((PPath)pNode);
                    PText pText = new PText(Integer.toString(n + 1));
                    pText.setFont(BOLD_LABEL_FONT);
                    pText.setScale(this._labelScalingFactor);
                    this._halfLifeLineLabels.add(pText);
                    this._nonPickableGraphLayer.addChild(pText);
                }
            }
            for (n = 0; n < this._halfLifeLines.size(); ++n) {
                pNode = this._halfLifeLines.get(n);
                ((PPath)pNode).setPathTo(new Line2D.Double(0.0, 0.0, 0.0, this._graphRect.getHeight()));
                double d = (double)(n + 1) * this._chart._halfLife * this._msToPixelsFactor + this._graphRect.getX();
                pNode.setOffset(d, this._graphRect.getY());
                PText pText = this._halfLifeLineLabels.get(n);
                pText.setScale(1.0);
                pText.setScale(this._labelScalingFactor);
                pText.setOffset(d - pText.getFullBoundsReference().width / 2.0, this._graphRect.getY() - pText.getFullBoundsReference().height);
            }
            this._upperXAxisLabel.setScale(1.0);
            this._upperXAxisLabel.setScale(this._labelScalingFactor);
            this._upperXAxisLabel.setOffset(this._graphRect.getCenterX() - this._upperXAxisLabel.getFullBoundsReference().width / 2.0, 0.0);
        }

        private void updateXAxisTickMarksAndLabels() {
            int n;
            for (PhetPPath pNode : this._xAxisTickMarks) {
                this._nonPickableGraphLayer.removeChild(pNode);
            }
            for (PText pText : this._xAxisTickMarkLabels) {
                this._nonPickableGraphLayer.removeChild(pText);
            }
            this._xAxisTickMarks.clear();
            this._xAxisTickMarkLabels.clear();
            PText pText = new PText();
            pText.setText("0.0");
            pText.setFont(BOLD_LABEL_FONT);
            pText.setScale(this._labelScalingFactor);
            pText.setOffset(this._graphRect.getX() - pText.getFullBoundsReference().width / 2.0, this._graphRect.getMaxY() + pText.getFullBoundsReference().height * 0.1);
            this._nonPickableGraphLayer.addChild(pText);
            this._xAxisTickMarkLabels.add(pText);
            boolean bl = false;
            if (this._chart._timeSpan < HalfLifeInfo.convertYearsToMs(100000.0)) {
                int n2 = (int)(this._chart._timeSpan / HalfLifeInfo.convertYearsToMs(5000.0));
                for (n = 0; n < n2; ++n) {
                    this.addXAxisTickMark((double)(n + 1) * HalfLifeInfo.convertYearsToMs(5000.0), NUMBER_FORMAT.format((n + 1) * 5000));
                }
            } else if (this._chart._timeSpan < HalfLifeInfo.convertYearsToMs(1000000.0)) {
                int n3 = (int)(this._chart._timeSpan / HalfLifeInfo.convertYearsToMs(100000.0));
                for (n = 0; n < n3; ++n) {
                    this.addXAxisTickMark((double)(n + 1) * HalfLifeInfo.convertYearsToMs(100000.0), NUMBER_FORMAT.format((n + 1) * 100000));
                }
            } else if (this._chart._timeSpan < HalfLifeInfo.convertYearsToMs(1.0E7)) {
                int n4 = (int)(this._chart._timeSpan / HalfLifeInfo.convertYearsToMs(1000000.0));
                for (n = 0; n < n4; ++n) {
                    this.addXAxisTickMark((double)(n + 1) * HalfLifeInfo.convertYearsToMs(1000000.0), String.format("%.1f", Float.valueOf(n + 1)));
                }
            } else if (this._chart._timeSpan < HalfLifeInfo.convertYearsToMs(1.0E8)) {
                int n5 = (int)(this._chart._timeSpan / HalfLifeInfo.convertYearsToMs(1.0E7));
                for (n = 0; n < n5; ++n) {
                    this.addXAxisTickMark((double)(n + 1) * HalfLifeInfo.convertYearsToMs(1.0E7), String.format("%.1f", Float.valueOf((n + 1) * 10)));
                }
            } else if (this._chart._timeSpan < HalfLifeInfo.convertYearsToMs(1.0E9)) {
                int n6 = (int)(this._chart._timeSpan / HalfLifeInfo.convertYearsToMs(1.0E8));
                for (n = 0; n < n6; ++n) {
                    this.addXAxisTickMark((double)(n + 1) * HalfLifeInfo.convertYearsToMs(1.0E8), String.format("%.0f", Float.valueOf((n + 1) * 100)));
                }
            } else {
                int n7 = (int)(this._chart._timeSpan / HalfLifeInfo.convertYearsToMs(4.0E9));
                for (n = 0; n < n7; ++n) {
                    this.addXAxisTickMark((double)(n + 1) * HalfLifeInfo.convertYearsToMs(4.0E9), String.format("%.1f", Float.valueOf((n + 1) * 4)));
                }
            }
            this._lowerXAxisLabel.setText(this.getXAxisUnitsText());
            this._lowerXAxisLabel.setScale(1.0);
            this._lowerXAxisLabel.setScale(this._labelScalingFactor);
            double d = this._graphRect.getMaxY() + 5.0;
            if (this._xAxisTickMarkLabels.size() > 0) {
                d = this._sizingRect.getHeight() - this._lowerXAxisLabel.getFullBoundsReference().height;
            }
            this._lowerXAxisLabel.setOffset(this._graphRect.getCenterX() - this._lowerXAxisLabel.getFullBoundsReference().width / 2.0, d);
        }

        private void addXAxisTickMark(double d, String string) {
            PhetPPath phetPPath = new PhetPPath(TICK_MARK_COLOR);
            phetPPath.setPathTo(new Line2D.Double(0.0, 0.0, 0.0, -3.0));
            phetPPath.setStroke(TICK_MARK_STROKE);
            phetPPath.setOffset(this._graphRect.getX() + d * this._msToPixelsFactor, this._graphRect.getMaxY());
            this._nonPickableGraphLayer.addChild(phetPPath);
            this._xAxisTickMarks.add(phetPPath);
            PText pText = new PText();
            pText.setText(string);
            pText.setFont(BOLD_LABEL_FONT);
            pText.setScale(this._labelScalingFactor);
            pText.setOffset(phetPPath.getOffset().getX() - pText.getFullBoundsReference().width / 2.0, this._graphRect.getMaxY() + pText.getFullBoundsReference().height * 0.1);
            this._nonPickableGraphLayer.addChild(pText);
            this._xAxisTickMarkLabels.add(pText);
        }

        private void updateDecayCurves() {
            this._dataPresentationLayer.removeAllChildren();
            this._preDecayProportionCurve = null;
            this._postDecayProportionCurve = null;
            Iterator<Point2D> iterator = this._chart._decayEvents.iterator();
            while (iterator.hasNext()) {
                this.graphDecayEvent(iterator.next());
            }
        }

        private void graphDecayEvent(Point2D point2D) {
            if (this._lineGraph) {
                this.graphDecayEventLine(point2D);
            } else {
                this.graphDecayEventPoint(point2D);
            }
        }

        private void graphDecayEventLine(Point2D point2D) {
            float f;
            float f2 = (float)(this._msToPixelsFactor * point2D.getX() + this._graphRect.getX());
            if ((double)f2 > this._graphRect.getMaxX() && (double)(f = (float)(this._msToPixelsFactor * this._previousDecayEvent.getX() + this._graphRect.getX())) <= this._graphRect.getMaxX()) {
                f2 = (float)this._graphRect.getMaxX();
            }
            if ((double)f2 <= this._graphRect.getMaxX()) {
                f = (float)(this._graphRect.getMaxY() - point2D.getY() / 100.0 * this._graphRect.getHeight());
                float f3 = (float)(this._graphRect.getMaxY() - (100.0 - point2D.getY()) / 100.0 * this._graphRect.getHeight());
                if (this._preDecayProportionCurve == null) {
                    this._preDecayProportionCurve = new PPath();
                    this._preDecayProportionCurve.setStroke(this._dataCurveStroke);
                    this._preDecayProportionCurve.setStrokePaint(this._chart._preDecayNucleusDisplayInfo.getDisplayColor());
                    this._dataPresentationLayer.addChild(this._preDecayProportionCurve);
                    if (point2D.getX() != 0.0) {
                        this._preDecayProportionCurve.moveTo((float)this._graphRect.getX(), f);
                        this._preDecayProportionCurve.lineTo(f2, f);
                    } else {
                        this._preDecayProportionCurve.moveTo(f2, f);
                    }
                } else {
                    this._preDecayProportionCurve.lineTo(f2, f);
                }
                if (this._postDecayProportionCurve == null) {
                    this._postDecayProportionCurve = new PPath();
                    this._postDecayProportionCurve.setStroke(this._dataCurveStroke);
                    this._postDecayProportionCurve.setStrokePaint(this._chart._postDecayNucleusDisplayInfo.getDisplayColor());
                    this._dataPresentationLayer.addChild(this._postDecayProportionCurve);
                    this._postDecayProportionCurve.setVisible(this._chart._showPostDecayCurve);
                    if (point2D.getX() != 0.0) {
                        this._postDecayProportionCurve.moveTo((float)this._graphRect.getX(), f3);
                        this._postDecayProportionCurve.lineTo(f2, f3);
                    } else {
                        this._postDecayProportionCurve.moveTo(f2, f3);
                    }
                } else {
                    this._postDecayProportionCurve.lineTo(f2, f3);
                }
            }
            this._previousDecayEvent = point2D;
        }

        private void graphDecayEventPoint(Point2D point2D) {
            float f = (float)(this._msToPixelsFactor * point2D.getX() + this._graphRect.getX());
            if ((double)f <= this._graphRect.getMaxX()) {
                float f2 = (float)(this._graphRect.getMaxY() - point2D.getY() / 100.0 * this._graphRect.getHeight());
                float f3 = (float)(this._graphRect.getMaxY() - (100.0 - point2D.getY()) / 100.0 * this._graphRect.getHeight());
                PhetPPath phetPPath = new PhetPPath(this._dataPointShape, this._chart._preDecayNucleusDisplayInfo.getDisplayColor(), null, this._chart._preDecayNucleusDisplayInfo.getDisplayColor());
                phetPPath.setOffset(f, f2);
                this._dataPresentationLayer.addChild(phetPPath);
                PhetPPath phetPPath2 = new PhetPPath(this._dataPointShape, this._chart._postDecayNucleusDisplayInfo.getDisplayColor(), null, this._chart._postDecayNucleusDisplayInfo.getDisplayColor());
                phetPPath2.setOffset(f, f3);
                phetPPath2.setVisible(this._chart._showPostDecayCurve);
                this._dataPresentationLayer.addChild(phetPPath2);
            }
            this._previousDecayEvent = point2D;
        }

        private String getXAxisUnitsText() {
            String string = this._chart._timeSpan > HalfLifeInfo.convertYearsToMs(1.0E9) ? NuclearPhysicsStrings.DECAY_PROPORTIONS_TIME_UNITS_BILLION_YEARS : (this._chart._timeSpan > HalfLifeInfo.convertYearsToMs(1000000.0) ? NuclearPhysicsStrings.DECAY_PROPORTIONS_TIME_UNITS_MILLION_YEARS : NuclearPhysicsStrings.DECAY_PROPORTIONS_TIME_UNITS_YEARS);
            return string;
        }
    }

    private static class MovablePercentIndicator
    extends PNode {
        private static final Color INDICATOR_OUTLINE_COLOR = new Color(85, 175, 205);
        private static final Color INDICATOR_BACKGROUND_COLOR = ColorUtils.brighterColor(NuclearPhysicsConstants.CHART_BACKGROUND_COLOR, 0.5);
        private static Stroke INDICATOR_STROKE = new BasicStroke(3.0f);
        private static final Font DEFAULT_FONT = new PhetFont(12, true);
        private PPath _readoutRect;
        private ResizeArrowNode _indicatorHandle;
        private PPath _indicatorLine;
        private PDragEventHandler _dragEventHandler;
        private NuclearDecayProportionChart _chart;
        private HTMLNode _percentageText;
        private PText _timeText;

        public MovablePercentIndicator(NuclearDecayProportionChart nuclearDecayProportionChart) {
            this._chart = nuclearDecayProportionChart;
            this.setPickable(true);
            this.setChildrenPickable(true);
            this._dragEventHandler = new PDragEventHandler(){

                public void startDrag(PInputEvent pInputEvent) {
                    super.startDrag(pInputEvent);
                    MovablePercentIndicator.this.handleMouseStartDragEvent(pInputEvent);
                }

                public void drag(PInputEvent pInputEvent) {
                    MovablePercentIndicator.this.handleMouseDragEvent(pInputEvent);
                }

                public void endDrag(PInputEvent pInputEvent) {
                    super.endDrag(pInputEvent);
                    MovablePercentIndicator.this.handleMouseEndDragEvent(pInputEvent);
                }
            };
            this._readoutRect = new PhetPPath(INDICATOR_BACKGROUND_COLOR, INDICATOR_STROKE, INDICATOR_OUTLINE_COLOR);
            this._readoutRect.setPickable(true);
            this._readoutRect.addInputEventListener(this._dragEventHandler);
            this.addChild(this._readoutRect);
            this._percentageText = new HTMLNode("---");
            this._percentageText.setFont(DEFAULT_FONT);
            this._percentageText.setPickable(true);
            this._readoutRect.addChild(this._percentageText);
            this._timeText = new PText("---");
            this._timeText.setFont(DEFAULT_FONT);
            this._timeText.setPickable(true);
            this._readoutRect.addChild(this._timeText);
            this._indicatorLine = new PhetPPath(INDICATOR_OUTLINE_COLOR, INDICATOR_STROKE, INDICATOR_OUTLINE_COLOR);
            this._indicatorLine.setPickable(true);
            this._indicatorLine.addInputEventListener(this._dragEventHandler);
            this.addChild(this._indicatorLine);
            this._indicatorHandle = new ResizeArrowNode(45.0, 0.0, Color.GREEN, Color.YELLOW);
            this._indicatorHandle.setPickable(true);
            this._indicatorHandle.addInputEventListener(this._dragEventHandler);
            this.addChild(this._indicatorHandle);
            this.addInputEventListener(new CursorHandler(11));
        }

        public void updateLayout(int n, int n2, int n3, int n4) {
            this._readoutRect.setPathTo(new RoundRectangle2D.Double(0.0, 0.0, n, n2, 10.0, 10.0));
            this.updateReadoutText();
            this.updateReadoutTextLayout();
            this._readoutRect.setOffset(200.0, this._chart._usableAreaRect.getX());
            this._indicatorLine.setPathTo(new Line2D.Double(0.0, 0.0, 0.0, n4 - n3));
            this._indicatorLine.setOffset(this._readoutRect.getOffset().getX() + this._readoutRect.getWidth() / 2.0, this._readoutRect.getOffset().getY() + this._readoutRect.getHeight());
            this._indicatorHandle.setOffset(this._readoutRect.getOffset().getX() + this._readoutRect.getWidth() / 2.0 - this._indicatorHandle.getWidth() / 2.0, this._readoutRect.getFullBoundsReference().getMaxY() + 0.5 * this._indicatorHandle.getFullBoundsReference().getHeight());
        }

        public void updateReadoutTextLayout() {
            this._percentageText.setScale(1.0);
            this._timeText.setScale(1.0);
            double d = this._readoutRect.getHeight() * 0.5 / this._percentageText.getFullBoundsReference().getHeight();
            this._percentageText.setScale(d);
            this._timeText.setScale(d);
            double d2 = this._readoutRect.getWidth() / 2.0;
            double d3 = this._readoutRect.getHeight() / 2.0;
            this._percentageText.setOffset(d2 - this._percentageText.getFullBoundsReference().width / 2.0, d3 - this._percentageText.getFullBoundsReference().height);
            this._timeText.setOffset(d2 - this._timeText.getFullBoundsReference().width / 2.0, d3);
        }

        public void updateReadoutText() {
            double d = this._chart.getDataValueForXPixelPos(this._readoutRect.getFullBoundsReference().getCenterX());
            String string = d >= 0.0 && d <= 100.0 ? String.format("%.1f", d) + " %" : "---";
            this._percentageText.setHTML("<html><sup><font size=-2>" + this._chart._preDecayNucleusDisplayInfo.getIsotopeNumberString() + " </font></sup>" + this._chart._preDecayNucleusDisplayInfo.getChemicalSymbol() + "= " + string + "</html>");
            double d2 = this._chart.getTimeValueForXPixelPos(this._readoutRect.getFullBoundsReference().getCenterX());
            String string2 = d2 < HalfLifeInfo.convertYearsToMs(1000000.0) ? NuclearPhysicsStrings.TIME_ABBREVIATION + " = " + Integer.toString((int)HalfLifeInfo.convertMsToYears(d2)) + " " + NuclearPhysicsStrings.TIME_GRAPH_UNITS_YRS : (d2 < HalfLifeInfo.convertYearsToMs(1.0E9) ? NuclearPhysicsStrings.TIME_ABBREVIATION + " = " + String.format("%.2f", HalfLifeInfo.convertMsToYears(d2) / 1000000.0) + " " + NuclearPhysicsStrings.DECAY_PROPORTIONS_TIME_UNITS_MILLION_YEARS_ABBREV : NuclearPhysicsStrings.TIME_ABBREVIATION + " = " + String.format("%.2f", HalfLifeInfo.convertMsToYears(d2) / 1.0E9) + " " + NuclearPhysicsStrings.DECAY_PROPORTIONS_TIME_UNITS_BILLION_YEARS_ABBREV);
            this._timeText.setText(string2);
            this.updateReadoutTextLayout();
        }

        private void handleMouseDragEvent(PInputEvent pInputEvent) {
            PNode pNode = pInputEvent.getPickedNode();
            PDimension pDimension = pInputEvent.getDeltaRelativeTo(pNode);
            pNode.localToParent(pDimension);
            double d = this._readoutRect.getOffset().getX() + pDimension.width;
            double d2 = d + this._readoutRect.getFullBoundsReference().width / 2.0;
            if (d2 < this._chart.getGraphOriginPos().getX()) {
                d = this._chart.getGraphOriginPos().getX() - this._readoutRect.getFullBoundsReference().width / 2.0;
            } else if (d2 > this._chart.getGraphMaxX()) {
                d = this._chart.getGraphMaxX() - this._readoutRect.getFullBoundsReference().width / 2.0;
            }
            this._readoutRect.setOffset(d, this._readoutRect.getOffset().getY());
            this.updateReadoutText();
            this._indicatorHandle.setOffset(d + this._readoutRect.getWidth() / 2.0 - this._indicatorHandle.getWidth() / 2.0, this._indicatorHandle.getOffset().getY());
            this._indicatorLine.setOffset(d + this._readoutRect.getWidth() / 2.0 - this._indicatorLine.getWidth() / 2.0, this._readoutRect.getOffset().getY() + this._readoutRect.getHeight());
        }

        private void handleMouseStartDragEvent(PInputEvent pInputEvent) {
        }

        private void handleMouseEndDragEvent(PInputEvent pInputEvent) {
        }
    }

    private static class ProportionsPieChartNode
    extends PNode {
        private static final int INITIAL_PIE_CHART_WIDTH = (int)Math.round(90.0);
        private static final Font LABEL_FONT = new PhetFont(16, true);
        private PieChartNode _pieChartNode;
        private NuclearDecayProportionChart _chart;
        private HTMLNode _preDecayLabel;
        private HTMLNode _postDecayLabel;
        private PText _numberPreDecayRemaining;
        private PText _numberPostDecayRemaining;
        private PhetPPath _boundsRect;
        private boolean _showBoundsRect = false;

        public ProportionsPieChartNode(NuclearDecayProportionChart nuclearDecayProportionChart) {
            this._chart = nuclearDecayProportionChart;
            this._boundsRect = new PhetPPath((Shape)new Rectangle2D.Double(0.0, 0.0, 100.0, 151.5151515151515), (Paint)Color.ORANGE);
            this._boundsRect.setPickable(false);
            this._boundsRect.setVisible(this._showBoundsRect);
            this.addChild(this._boundsRect);
            PieChartNode.PieValue[] pieValueArray = new PieChartNode.PieValue[]{new PieChartNode.PieValue(100.0, this._chart._preDecayNucleusDisplayInfo.getDisplayColor()), new PieChartNode.PieValue(0.0, this._chart._postDecayNucleusDisplayInfo.getDisplayColor())};
            this._pieChartNode = new PieChartNode(pieValueArray, new Rectangle(INITIAL_PIE_CHART_WIDTH, INITIAL_PIE_CHART_WIDTH));
            this._pieChartNode.setOffset(50.0 - this._pieChartNode.getFullBoundsReference().width / 2.0, 75.75757575757575 - this._pieChartNode.getFullBounds().height / 2.0);
            this.addChild(this._pieChartNode);
            HTMLNode hTMLNode = new HTMLNode("<html><sup><font size=-1>12</font></sup>XX");
            hTMLNode.setFont(LABEL_FONT);
            hTMLNode.setScale(1.5);
            this._preDecayLabel = new HTMLNode();
            this._preDecayLabel.setFont(LABEL_FONT);
            this._preDecayLabel.setScale(1.5);
            this._preDecayLabel.setOffset(0.0, 0.0);
            this.addChild(this._preDecayLabel);
            this._postDecayLabel = new HTMLNode();
            this._postDecayLabel.setFont(LABEL_FONT);
            this._postDecayLabel.setScale(1.5);
            this._postDecayLabel.setOffset(0.0, this._boundsRect.getHeight() - hTMLNode.getFullBoundsReference().height);
            this.addChild(this._postDecayLabel);
            this._numberPreDecayRemaining = new PText();
            this._numberPreDecayRemaining.setFont(LABEL_FONT);
            this._numberPreDecayRemaining.setScale(1.5);
            this.addChild(this._numberPreDecayRemaining);
            this._numberPostDecayRemaining = new PText();
            this._numberPostDecayRemaining.setFont(LABEL_FONT);
            this._numberPostDecayRemaining.setScale(1.5);
            this.addChild(this._numberPostDecayRemaining);
            this.reset();
        }

        public void setAmounts(int n, int n2) {
            this._numberPreDecayRemaining.setText(Integer.toString(n));
            this._numberPostDecayRemaining.setText(Integer.toString(n2));
            if (n == 0 && n2 == 0) {
                n = 1;
            }
            PieChartNode.PieValue[] pieValueArray = new PieChartNode.PieValue[]{new PieChartNode.PieValue(n, this._chart._preDecayNucleusDisplayInfo.getDisplayColor()), new PieChartNode.PieValue(n2, this._chart._postDecayNucleusDisplayInfo.getDisplayColor())};
            this._pieChartNode.setPieValues(pieValueArray);
            this.updateTextPositions();
        }

        public void reset() {
            this.setAmounts(0, 0);
            this._preDecayLabel.setHTMLColor(this._chart._preDecayNucleusDisplayInfo.getDisplayColor());
            this._preDecayLabel.setHTML("<html><sup><font size=-1>" + this._chart._preDecayNucleusDisplayInfo.getIsotopeNumberString() + " </font></sup>" + this._chart._preDecayNucleusDisplayInfo.getChemicalSymbol() + "</html>");
            this._postDecayLabel.setHTMLColor(this._chart._postDecayNucleusDisplayInfo.getDisplayColor());
            this._postDecayLabel.setHTML("<html><sup><font size=-1>" + this._chart._postDecayNucleusDisplayInfo.getIsotopeNumberString() + " </font></sup>" + this._chart._postDecayNucleusDisplayInfo.getChemicalSymbol() + "</html>");
            this.updateTextPositions();
        }

        private void updateTextPositions() {
            this._numberPreDecayRemaining.setOffset(this._boundsRect.getFullBoundsReference().getMaxX() - this._numberPreDecayRemaining.getFullBoundsReference().width, this._preDecayLabel.getFullBoundsReference().getMaxY() - this._numberPostDecayRemaining.getFullBoundsReference().height);
            this._numberPostDecayRemaining.setOffset(this._boundsRect.getFullBoundsReference().getMaxX() - this._numberPostDecayRemaining.getFullBoundsReference().width, this._boundsRect.getFullBoundsReference().getMaxY() - this._numberPostDecayRemaining.getFullBoundsReference().height);
        }
    }
}

