/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.nuclearreactor;

import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.common.NuclearPhysicsClock;
import edu.colorado.phet.nuclearphysics.control.NuclearPhysicsClockControlPanel;
import edu.colorado.phet.nuclearphysics.module.nuclearreactor.NuclearReactorCanvas;
import edu.colorado.phet.nuclearphysics.module.nuclearreactor.NuclearReactorControlPanel;
import edu.colorado.phet.nuclearphysics.module.nuclearreactor.NuclearReactorModel;
import java.awt.Frame;

public class NuclearReactorModule
extends PiccoloModule {
    private NuclearReactorModel _model;
    private NuclearReactorCanvas _canvas;
    private NuclearReactorControlPanel _controlPanel;
    private NuclearPhysicsClockControlPanel _clockControlPanel;

    public NuclearReactorModule(Frame frame) {
        super(NuclearPhysicsStrings.TITLE_NUCLEAR_REACTOR_MODULE, new NuclearPhysicsClock(25, 40.0));
        NuclearPhysicsClock nuclearPhysicsClock = (NuclearPhysicsClock)this.getClock();
        this._model = new NuclearReactorModel(nuclearPhysicsClock);
        this._canvas = new NuclearReactorCanvas(this._model, frame);
        this.setSimulationPanel(this._canvas);
        this._controlPanel = new NuclearReactorControlPanel(this, frame);
        this.setControlPanel(this._controlPanel);
        this._clockControlPanel = new NuclearPhysicsClockControlPanel(this.getClock());
        this.setClockControlPanel(this._clockControlPanel);
        if (this.hasHelp()) {
            // empty if block
        }
        this.reset();
    }

    public void reset() {
        this._model.getClock().resetSimulationTime();
        this.setClockRunningWhenActive(true);
    }

    public NuclearReactorModel getNuclearReactorModel() {
        return this._model;
    }
}

