/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.model;

import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.nuclearphysics.common.NuclearPhysicsClock;
import edu.colorado.phet.nuclearphysics.model.AlphaDecayCompositeNucleus;
import java.awt.geom.Point2D;

public class AdjustableHalfLifeCompositeNucleus
extends AlphaDecayCompositeNucleus {
    public AdjustableHalfLifeCompositeNucleus(NuclearPhysicsClock nuclearPhysicsClock, Point2D point2D) {
        super(nuclearPhysicsClock, point2D, 83, 125);
    }

    protected void updateAgitationFactor() {
        switch (this._numProtons) {
            case 83: {
                this._agitationFactor = 5;
                break;
            }
            case 81: {
                this._agitationFactor = 1;
                break;
            }
            default: {
                System.err.println("Error: Unexpected atomic weight in alpha decay nucleus.");
                assert (false);
                break;
            }
        }
    }

    public double getAdjustedActivatedTime() {
        return this.convertSimTimeToExponentialTime(this.getActivatedSimTime());
    }

    protected boolean isTimeToDecay(ClockEvent clockEvent) {
        double d = this.convertSimTimeToExponentialTime(this.getActivatedSimTime());
        return d > this.getTotalUndecayedLifetime();
    }

    private double convertSimTimeToExponentialTime(double d) {
        return Math.pow(10.0, d * 0.01) - 1.0;
    }
}

