/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.dialog;

import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.resources.PhetResources;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsResources;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class ReactorPictureDialog
extends PaintImmediateDialog {
    private static final Font CAPTION_FONT = new PhetFont(12);

    public ReactorPictureDialog(Frame frame) {
        super(frame, true);
        this.setResizable(false);
        BufferedImage bufferedImage = NuclearPhysicsResources.getImage("reactor_core.gif");
        JLabel jLabel = new JLabel(new ImageIcon(bufferedImage));
        jLabel.setSize(bufferedImage.getWidth(), bufferedImage.getHeight());
        JTextArea jTextArea = new JTextArea(NuclearPhysicsStrings.REACTOR_PICTURE_CAPTION);
        jTextArea.setFont(CAPTION_FONT);
        jTextArea.setColumns(30);
        jTextArea.setEditable(false);
        jTextArea.setOpaque(false);
        if (ComponentOrientation.getOrientation(PhetResources.readLocale()).isLeftToRight()) {
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
        }
        JButton jButton = new JButton(NuclearPhysicsStrings.CLOSE_BUTTON_CAPTION);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReactorPictureDialog.this.dispose();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel);
        easyGridBagLayout.setInsets(new Insets(10, 0, 10, 0));
        easyGridBagLayout.setAnchor(10);
        jPanel.setLayout(easyGridBagLayout);
        easyGridBagLayout.addComponent(jLabel, 0, 0);
        easyGridBagLayout.addComponent(jTextArea, 1, 0);
        easyGridBagLayout.addComponent(jButton, 2, 0);
        this.getContentPane().add(jPanel);
        this.pack();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.pack();
        }
    }
}

