/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.APIUtil;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.opencl.CLCommandQueue;
import org.lwjgl.opencl.CLContext;
import org.lwjgl.opencl.CLContextCallback;
import org.lwjgl.opencl.CLDevice;
import org.lwjgl.opencl.CLEvent;
import org.lwjgl.opencl.CLKernel;
import org.lwjgl.opencl.CLMem;
import org.lwjgl.opencl.CLObject;
import org.lwjgl.opencl.CLPlatform;
import org.lwjgl.opencl.CLProgram;
import org.lwjgl.opencl.CLSampler;
import org.lwjgl.opencl.CallbackUtil;

public final class CL10 {
    private CL10() {
    }

    public static int clGetPlatformIDs(PointerBuffer platforms, IntBuffer num_platforms) {
        int __result;
        long function_pointer = CLCapabilities.clGetPlatformIDs;
        BufferChecks.checkFunctionAddress(function_pointer);
        if (platforms != null) {
            BufferChecks.checkDirect(platforms);
        }
        if (num_platforms != null) {
            BufferChecks.checkBuffer(num_platforms, 1);
        }
        if (num_platforms == null) {
            num_platforms = APIUtil.getBufferInt();
        }
        if ((__result = CL10.nclGetPlatformIDs(platforms == null ? 0 : platforms.remaining(), platforms != null ? platforms.getBuffer() : null, platforms != null ? platforms.positionByte() : 0, num_platforms, num_platforms != null ? num_platforms.position() : 0, function_pointer)) == 0 && platforms != null) {
            CLPlatform.registerCLPlatforms(platforms, num_platforms);
        }
        return __result;
    }

    static native int nclGetPlatformIDs(int var0, ByteBuffer var1, int var2, IntBuffer var3, int var4, long var5);

    public static int clGetPlatformInfo(CLPlatform platform, int param_name, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        long function_pointer = CLCapabilities.clGetPlatformInfo;
        BufferChecks.checkFunctionAddress(function_pointer);
        if (param_value != null) {
            BufferChecks.checkDirect(param_value);
        }
        if (param_value_size_ret != null) {
            BufferChecks.checkBuffer(param_value_size_ret, 1);
        }
        int __result = CL10.nclGetPlatformInfo(platform == null ? 0L : platform.getPointer(), param_name, param_value == null ? 0 : param_value.remaining(), param_value, param_value != null ? param_value.position() : 0, param_value_size_ret != null ? param_value_size_ret.getBuffer() : null, param_value_size_ret != null ? param_value_size_ret.positionByte() : 0, function_pointer);
        return __result;
    }

    static native int nclGetPlatformInfo(long var0, int var2, long var3, ByteBuffer var5, int var6, ByteBuffer var7, int var8, long var9);

    public static int clGetDeviceIDs(CLPlatform platform, long device_type, PointerBuffer devices, IntBuffer num_devices) {
        long function_pointer = CLCapabilities.clGetDeviceIDs;
        BufferChecks.checkFunctionAddress(function_pointer);
        if (devices != null) {
            BufferChecks.checkDirect(devices);
        }
        if (num_devices != null) {
            BufferChecks.checkBuffer(num_devices, 1);
        } else {
            num_devices = APIUtil.getBufferInt();
        }
        int __result = CL10.nclGetDeviceIDs(platform.getPointer(), device_type, devices == null ? 0 : devices.remaining(), devices != null ? devices.getBuffer() : null, devices != null ? devices.positionByte() : 0, num_devices, num_devices != null ? num_devices.position() : 0, function_pointer);
        if (__result == 0 && devices != null) {
            platform.registerCLDevices(devices, num_devices);
        }
        return __result;
    }

    static native int nclGetDeviceIDs(long var0, long var2, int var4, ByteBuffer var5, int var6, IntBuffer var7, int var8, long var9);

    public static int clGetDeviceInfo(CLDevice device, int param_name, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        long function_pointer = CLCapabilities.clGetDeviceInfo;
        BufferChecks.checkFunctionAddress(function_pointer);
        if (param_value != null) {
            BufferChecks.checkDirect(param_value);
        }
        if (param_value_size_ret != null) {
            BufferChecks.checkBuffer(param_value_size_ret, 1);
        }
        int __result = CL10.nclGetDeviceInfo(device.getPointer(), param_name, param_value == null ? 0 : param_value.remaining(), param_value, param_value != null ? param_value.position() : 0, param_value_size_ret != null ? param_value_size_ret.getBuffer() : null, param_value_size_ret != null ? param_value_size_ret.positionByte() : 0, function_pointer);
        return __result;
    }

    static native int nclGetDeviceInfo(long var0, int var2, long var3, ByteBuffer var5, int var6, ByteBuffer var7, int var8, long var9);

    static native long nclCreateContext(ByteBuffer var0, int var1, int var2, ByteBuffer var3, int var4, long var5, long var7, IntBuffer var9, int var10, long var11);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CLContext clCreateContextFromType(PointerBuffer properties, long device_type, CLContextCallback pfn_notify, IntBuffer errcode_ret) {
        CLContext cLContext;
        long function_pointer = CLCapabilities.clCreateContextFromType;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkBuffer(properties, 3);
        BufferChecks.checkNullTerminated(properties);
        if (errcode_ret != null) {
            BufferChecks.checkBuffer(errcode_ret, 1);
        }
        long user_data = CallbackUtil.createGlobalRef(pfn_notify);
        CLContext __result = null;
        try {
            cLContext = __result = new CLContext(CL10.nclCreateContextFromType(properties.getBuffer(), properties.positionByte(), device_type, pfn_notify == null ? 0L : pfn_notify.getPointer(), user_data, errcode_ret, errcode_ret != null ? errcode_ret.position() : 0, function_pointer), APIUtil.getCLPlatform(properties));
        }
        catch (Throwable throwable) {
            CallbackUtil.registerCallback(__result, user_data);
            throw throwable;
        }
        CallbackUtil.registerCallback(__result, user_data);
        return cLContext;
    }

    static native long nclCreateContextFromType(ByteBuffer var0, int var1, long var2, long var4, long var6, IntBuffer var8, int var9, long var10);

    public static int clGetContextInfo(CLContext context, int param_name, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        int __result;
        long function_pointer = CLCapabilities.clGetContextInfo;
        BufferChecks.checkFunctionAddress(function_pointer);
        if (param_value != null) {
            BufferChecks.checkDirect(param_value);
        }
        if (param_value_size_ret != null) {
            BufferChecks.checkBuffer(param_value_size_ret, 1);
        }
        if (param_value_size_ret == null && APIUtil.isDevicesParam(param_name)) {
            param_value_size_ret = APIUtil.getBufferPointer();
        }
        if ((__result = CL10.nclGetContextInfo(context.getPointer(), param_name, param_value == null ? 0 : param_value.remaining(), param_value, param_value != null ? param_value.position() : 0, param_value_size_ret != null ? param_value_size_ret.getBuffer() : null, param_value_size_ret != null ? param_value_size_ret.positionByte() : 0, function_pointer)) == 0 && param_value != null && APIUtil.isDevicesParam(param_name)) {
            ((CLPlatform)context.getParent()).registerCLDevices(param_value, param_value_size_ret);
        }
        return __result;
    }

    static native int nclGetContextInfo(long var0, int var2, long var3, ByteBuffer var5, int var6, ByteBuffer var7, int var8, long var9);

    public static int clGetCommandQueueInfo(CLCommandQueue command_queue, int param_name, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        long function_pointer = CLCapabilities.clGetCommandQueueInfo;
        BufferChecks.checkFunctionAddress(function_pointer);
        if (param_value != null) {
            BufferChecks.checkDirect(param_value);
        }
        if (param_value_size_ret != null) {
            BufferChecks.checkBuffer(param_value_size_ret, 1);
        }
        int __result = CL10.nclGetCommandQueueInfo(command_queue.getPointer(), param_name, param_value == null ? 0 : param_value.remaining(), param_value, param_value != null ? param_value.position() : 0, param_value_size_ret != null ? param_value_size_ret.getBuffer() : null, param_value_size_ret != null ? param_value_size_ret.positionByte() : 0, function_pointer);
        return __result;
    }

    static native int nclGetCommandQueueInfo(long var0, int var2, long var3, ByteBuffer var5, int var6, ByteBuffer var7, int var8, long var9);

    static native long nclCreateImage2D(long var0, long var2, ByteBuffer var4, int var5, long var6, long var8, long var10, Buffer var12, int var13, IntBuffer var14, int var15, long var16);

    static native long nclCreateImage3D(long var0, long var2, ByteBuffer var4, int var5, long var6, long var8, long var10, long var12, long var14, Buffer var16, int var17, IntBuffer var18, int var19, long var20);

    public static int clGetSupportedImageFormats(CLContext context, long flags, int image_type, ByteBuffer image_formats, IntBuffer num_image_formats) {
        long function_pointer = CLCapabilities.clGetSupportedImageFormats;
        BufferChecks.checkFunctionAddress(function_pointer);
        if (image_formats != null) {
            BufferChecks.checkDirect(image_formats);
        }
        if (num_image_formats != null) {
            BufferChecks.checkBuffer(num_image_formats, 1);
        }
        int __result = CL10.nclGetSupportedImageFormats(context.getPointer(), flags, image_type, (image_formats == null ? 0 : image_formats.remaining()) / 8, image_formats, image_formats != null ? image_formats.position() : 0, num_image_formats, num_image_formats != null ? num_image_formats.position() : 0, function_pointer);
        return __result;
    }

    static native int nclGetSupportedImageFormats(long var0, long var2, int var4, int var5, ByteBuffer var6, int var7, IntBuffer var8, int var9, long var10);

    public static int clGetImageInfo(CLMem image, int param_name, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        long function_pointer = CLCapabilities.clGetImageInfo;
        BufferChecks.checkFunctionAddress(function_pointer);
        if (param_value != null) {
            BufferChecks.checkDirect(param_value);
        }
        if (param_value_size_ret != null) {
            BufferChecks.checkBuffer(param_value_size_ret, 1);
        }
        int __result = CL10.nclGetImageInfo(image.getPointer(), param_name, param_value == null ? 0 : param_value.remaining(), param_value, param_value != null ? param_value.position() : 0, param_value_size_ret != null ? param_value_size_ret.getBuffer() : null, param_value_size_ret != null ? param_value_size_ret.positionByte() : 0, function_pointer);
        return __result;
    }

    static native int nclGetImageInfo(long var0, int var2, long var3, ByteBuffer var5, int var6, ByteBuffer var7, int var8, long var9);

    public static int clGetMemObjectInfo(CLMem memobj, int param_name, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        long function_pointer = CLCapabilities.clGetMemObjectInfo;
        BufferChecks.checkFunctionAddress(function_pointer);
        if (param_value != null) {
            BufferChecks.checkDirect(param_value);
        }
        if (param_value_size_ret != null) {
            BufferChecks.checkBuffer(param_value_size_ret, 1);
        }
        int __result = CL10.nclGetMemObjectInfo(memobj.getPointer(), param_name, param_value == null ? 0 : param_value.remaining(), param_value, param_value != null ? param_value.position() : 0, param_value_size_ret != null ? param_value_size_ret.getBuffer() : null, param_value_size_ret != null ? param_value_size_ret.positionByte() : 0, function_pointer);
        return __result;
    }

    static native int nclGetMemObjectInfo(long var0, int var2, long var3, ByteBuffer var5, int var6, ByteBuffer var7, int var8, long var9);

    public static int clGetSamplerInfo(CLSampler sampler, int param_name, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        long function_pointer = CLCapabilities.clGetSamplerInfo;
        BufferChecks.checkFunctionAddress(function_pointer);
        if (param_value != null) {
            BufferChecks.checkDirect(param_value);
        }
        if (param_value_size_ret != null) {
            BufferChecks.checkBuffer(param_value_size_ret, 1);
        }
        int __result = CL10.nclGetSamplerInfo(sampler.getPointer(), param_name, param_value == null ? 0 : param_value.remaining(), param_value, param_value != null ? param_value.position() : 0, param_value_size_ret != null ? param_value_size_ret.getBuffer() : null, param_value_size_ret != null ? param_value_size_ret.positionByte() : 0, function_pointer);
        return __result;
    }

    static native int nclGetSamplerInfo(long var0, int var2, long var3, ByteBuffer var5, int var6, ByteBuffer var7, int var8, long var9);

    public static int clGetProgramInfo(CLProgram program, int param_name, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        long function_pointer = CLCapabilities.clGetProgramInfo;
        BufferChecks.checkFunctionAddress(function_pointer);
        if (param_value != null) {
            BufferChecks.checkDirect(param_value);
        }
        if (param_value_size_ret != null) {
            BufferChecks.checkBuffer(param_value_size_ret, 1);
        }
        int __result = CL10.nclGetProgramInfo(program.getPointer(), param_name, param_value == null ? 0 : param_value.remaining(), param_value, param_value != null ? param_value.position() : 0, param_value_size_ret != null ? param_value_size_ret.getBuffer() : null, param_value_size_ret != null ? param_value_size_ret.positionByte() : 0, function_pointer);
        return __result;
    }

    static native int nclGetProgramInfo(long var0, int var2, long var3, ByteBuffer var5, int var6, ByteBuffer var7, int var8, long var9);

    public static int clGetProgramInfo(CLProgram program, PointerBuffer sizes, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        long function_pointer = CLCapabilities.clGetProgramInfo;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkBuffer(sizes, 1);
        BufferChecks.checkBuffer(param_value, APIUtil.getSize(sizes));
        if (param_value_size_ret != null) {
            BufferChecks.checkBuffer(param_value_size_ret, 1);
        }
        int __result = CL10.nclGetProgramInfo2(program.getPointer(), 4454, sizes.remainingByte(), sizes.getBuffer(), sizes.positionByte(), param_value, param_value.position(), param_value_size_ret != null ? param_value_size_ret.getBuffer() : null, param_value_size_ret != null ? param_value_size_ret.positionByte() : 0, function_pointer);
        return __result;
    }

    static native int nclGetProgramInfo2(long var0, int var2, long var3, ByteBuffer var5, int var6, ByteBuffer var7, int var8, ByteBuffer var9, int var10, long var11);

    public static int clGetProgramInfo(CLProgram program, ByteBuffer[] param_value, PointerBuffer param_value_size_ret) {
        long function_pointer = CLCapabilities.clGetProgramInfo;
        BufferChecks.checkFunctionAddress(function_pointer);
        BufferChecks.checkArray(param_value);
        if (param_value_size_ret != null) {
            BufferChecks.checkBuffer(param_value_size_ret, 1);
        }
        int __result = CL10.nclGetProgramInfo3(program.getPointer(), 4454, param_value.length * PointerBuffer.getPointerSize(), param_value, param_value_size_ret != null ? param_value_size_ret.getBuffer() : null, param_value_size_ret != null ? param_value_size_ret.positionByte() : 0, function_pointer);
        return __result;
    }

    static native int nclGetProgramInfo3(long var0, int var2, long var3, ByteBuffer[] var5, ByteBuffer var6, int var7, long var8);

    public static int clGetProgramBuildInfo(CLProgram program, CLDevice device, int param_name, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        long function_pointer = CLCapabilities.clGetProgramBuildInfo;
        BufferChecks.checkFunctionAddress(function_pointer);
        if (param_value != null) {
            BufferChecks.checkDirect(param_value);
        }
        if (param_value_size_ret != null) {
            BufferChecks.checkBuffer(param_value_size_ret, 1);
        }
        int __result = CL10.nclGetProgramBuildInfo(program.getPointer(), device.getPointer(), param_name, param_value == null ? 0 : param_value.remaining(), param_value, param_value != null ? param_value.position() : 0, param_value_size_ret != null ? param_value_size_ret.getBuffer() : null, param_value_size_ret != null ? param_value_size_ret.positionByte() : 0, function_pointer);
        return __result;
    }

    static native int nclGetProgramBuildInfo(long var0, long var2, int var4, long var5, ByteBuffer var7, int var8, ByteBuffer var9, int var10, long var11);

    public static int clCreateKernelsInProgram(CLProgram program, PointerBuffer kernels, IntBuffer num_kernels_ret) {
        int __result;
        long function_pointer = CLCapabilities.clCreateKernelsInProgram;
        BufferChecks.checkFunctionAddress(function_pointer);
        if (kernels != null) {
            BufferChecks.checkDirect(kernels);
        }
        if (num_kernels_ret != null) {
            BufferChecks.checkBuffer(num_kernels_ret, 1);
        }
        if ((__result = CL10.nclCreateKernelsInProgram(program.getPointer(), kernels == null ? 0 : kernels.remaining(), kernels != null ? kernels.getBuffer() : null, kernels != null ? kernels.positionByte() : 0, num_kernels_ret, num_kernels_ret != null ? num_kernels_ret.position() : 0, function_pointer)) == 0 && kernels != null) {
            program.registerCLKernels(kernels);
        }
        return __result;
    }

    static native int nclCreateKernelsInProgram(long var0, int var2, ByteBuffer var3, int var4, IntBuffer var5, int var6, long var7);

    static native int nclSetKernelArg(long var0, int var2, long var3, Buffer var5, int var6, long var7);

    public static int clSetKernelArg(CLKernel kernel, int arg_index, CLObject arg_value) {
        long function_pointer = CLCapabilities.clSetKernelArg;
        BufferChecks.checkFunctionAddress(function_pointer);
        int __result = CL10.nclSetKernelArg(kernel.getPointer(), arg_index, PointerBuffer.getPointerSize(), APIUtil.getBufferPointer().put(0, arg_value == null ? 0L : arg_value.getPointer()).getBuffer(), 0, function_pointer);
        return __result;
    }

    public static int clSetKernelArg(CLKernel kernel, int arg_index, long arg_size) {
        long function_pointer = CLCapabilities.clSetKernelArg;
        BufferChecks.checkFunctionAddress(function_pointer);
        int __result = CL10.nclSetKernelArg(kernel.getPointer(), arg_index, arg_size, null, 0, function_pointer);
        return __result;
    }

    static int clSetKernelArg(CLKernel kernel, int arg_index, long arg_size, Buffer arg_value) {
        long function_pointer = CLCapabilities.clSetKernelArg;
        BufferChecks.checkFunctionAddress(function_pointer);
        int __result = CL10.nclSetKernelArg(kernel.getPointer(), arg_index, arg_size, arg_value, 0, function_pointer);
        return __result;
    }

    public static int clGetKernelInfo(CLKernel kernel, int param_name, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        long function_pointer = CLCapabilities.clGetKernelInfo;
        BufferChecks.checkFunctionAddress(function_pointer);
        if (param_value != null) {
            BufferChecks.checkDirect(param_value);
        }
        if (param_value_size_ret != null) {
            BufferChecks.checkBuffer(param_value_size_ret, 1);
        }
        int __result = CL10.nclGetKernelInfo(kernel.getPointer(), param_name, param_value == null ? 0 : param_value.remaining(), param_value, param_value != null ? param_value.position() : 0, param_value_size_ret != null ? param_value_size_ret.getBuffer() : null, param_value_size_ret != null ? param_value_size_ret.positionByte() : 0, function_pointer);
        return __result;
    }

    static native int nclGetKernelInfo(long var0, int var2, long var3, ByteBuffer var5, int var6, ByteBuffer var7, int var8, long var9);

    public static int clGetKernelWorkGroupInfo(CLKernel kernel, CLDevice device, int param_name, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        long function_pointer = CLCapabilities.clGetKernelWorkGroupInfo;
        BufferChecks.checkFunctionAddress(function_pointer);
        if (param_value != null) {
            BufferChecks.checkDirect(param_value);
        }
        if (param_value_size_ret != null) {
            BufferChecks.checkBuffer(param_value_size_ret, 1);
        }
        int __result = CL10.nclGetKernelWorkGroupInfo(kernel.getPointer(), device == null ? 0L : device.getPointer(), param_name, param_value == null ? 0 : param_value.remaining(), param_value, param_value != null ? param_value.position() : 0, param_value_size_ret != null ? param_value_size_ret.getBuffer() : null, param_value_size_ret != null ? param_value_size_ret.positionByte() : 0, function_pointer);
        return __result;
    }

    static native int nclGetKernelWorkGroupInfo(long var0, long var2, int var4, long var5, ByteBuffer var7, int var8, ByteBuffer var9, int var10, long var11);

    public static int clGetEventInfo(CLEvent event, int param_name, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        long function_pointer = CLCapabilities.clGetEventInfo;
        BufferChecks.checkFunctionAddress(function_pointer);
        if (param_value != null) {
            BufferChecks.checkDirect(param_value);
        }
        if (param_value_size_ret != null) {
            BufferChecks.checkBuffer(param_value_size_ret, 1);
        }
        int __result = CL10.nclGetEventInfo(event.getPointer(), param_name, param_value == null ? 0 : param_value.remaining(), param_value, param_value != null ? param_value.position() : 0, param_value_size_ret != null ? param_value_size_ret.getBuffer() : null, param_value_size_ret != null ? param_value_size_ret.positionByte() : 0, function_pointer);
        return __result;
    }

    static native int nclGetEventInfo(long var0, int var2, long var3, ByteBuffer var5, int var6, ByteBuffer var7, int var8, long var9);

    public static int clGetEventProfilingInfo(CLEvent event, int param_name, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        long function_pointer = CLCapabilities.clGetEventProfilingInfo;
        BufferChecks.checkFunctionAddress(function_pointer);
        if (param_value != null) {
            BufferChecks.checkDirect(param_value);
        }
        if (param_value_size_ret != null) {
            BufferChecks.checkBuffer(param_value_size_ret, 1);
        }
        int __result = CL10.nclGetEventProfilingInfo(event.getPointer(), param_name, param_value == null ? 0 : param_value.remaining(), param_value, param_value != null ? param_value.position() : 0, param_value_size_ret != null ? param_value_size_ret.getBuffer() : null, param_value_size_ret != null ? param_value_size_ret.positionByte() : 0, function_pointer);
        return __result;
    }

    static native int nclGetEventProfilingInfo(long var0, int var2, long var3, ByteBuffer var5, int var6, ByteBuffer var7, int var8, long var9);
}

