/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.java.games.input.Event;
import net.java.games.input.EventQueue;
import net.java.games.input.LinuxDevice;
import net.java.games.input.LinuxJoystickAxis;
import net.java.games.input.LinuxJoystickButton;
import net.java.games.input.LinuxJoystickEvent;
import net.java.games.input.LinuxJoystickPOV;

final class LinuxJoystickDevice
implements LinuxDevice {
    private final long fd;
    private final String name;
    private final LinuxJoystickEvent joystick_event = new LinuxJoystickEvent();
    private final Event event = new Event();
    private final LinuxJoystickButton[] buttons;
    private final LinuxJoystickAxis[] axes;
    private final Map povXs = new HashMap();
    private final Map povYs = new HashMap();
    private final byte[] axisMap;
    private final char[] buttonMap;
    private EventQueue event_queue;
    private boolean closed;

    public LinuxJoystickDevice(String filename) throws IOException {
        this.fd = LinuxJoystickDevice.nOpen(filename);
        try {
            this.name = this.getDeviceName();
            this.setBufferSize(32);
            this.buttons = new LinuxJoystickButton[this.getNumDeviceButtons()];
            this.axes = new LinuxJoystickAxis[this.getNumDeviceAxes()];
            this.axisMap = this.getDeviceAxisMap();
            this.buttonMap = this.getDeviceButtonMap();
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    private static final native long nOpen(String var0) throws IOException;

    public final synchronized void setBufferSize(int size) {
        this.event_queue = new EventQueue(size);
    }

    public final void registerAxis(int index, LinuxJoystickAxis axis) {
        this.axes[index] = axis;
    }

    public final void registerButton(int index, LinuxJoystickButton button) {
        this.buttons[index] = button;
    }

    public final void registerPOV(LinuxJoystickPOV pov) {
        int yIndex;
        int xIndex;
        LinuxJoystickAxis xAxis = pov.getYAxis();
        LinuxJoystickAxis yAxis = pov.getXAxis();
        for (xIndex = 0; xIndex < this.axes.length && this.axes[xIndex] != xAxis; ++xIndex) {
        }
        for (yIndex = 0; yIndex < this.axes.length && this.axes[yIndex] != yAxis; ++yIndex) {
        }
        this.povXs.put(new Integer(xIndex), pov);
        this.povYs.put(new Integer(yIndex), pov);
    }

    public final int getNumAxes() {
        return this.axes.length;
    }

    public final int getNumButtons() {
        return this.buttons.length;
    }

    public final byte[] getAxisMap() {
        return this.axisMap;
    }

    public final char[] getButtonMap() {
        return this.buttonMap;
    }

    private final int getNumDeviceButtons() throws IOException {
        return LinuxJoystickDevice.nGetNumButtons(this.fd);
    }

    private static final native int nGetNumButtons(long var0) throws IOException;

    private final int getNumDeviceAxes() throws IOException {
        return LinuxJoystickDevice.nGetNumAxes(this.fd);
    }

    private static final native int nGetNumAxes(long var0) throws IOException;

    private final byte[] getDeviceAxisMap() throws IOException {
        return LinuxJoystickDevice.nGetAxisMap(this.fd);
    }

    private static final native byte[] nGetAxisMap(long var0) throws IOException;

    private final char[] getDeviceButtonMap() throws IOException {
        return LinuxJoystickDevice.nGetButtonMap(this.fd);
    }

    private static final native char[] nGetButtonMap(long var0) throws IOException;

    public final String getName() {
        return this.name;
    }

    private final String getDeviceName() throws IOException {
        return LinuxJoystickDevice.nGetName(this.fd);
    }

    private static final native String nGetName(long var0) throws IOException;

    public final synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            LinuxJoystickDevice.nClose(this.fd);
        }
    }

    private static final native void nClose(long var0) throws IOException;

    protected void finalize() throws IOException {
        this.close();
    }
}

