/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.lwjglphet.nodes;

import edu.colorado.phet.common.phetcommon.model.event.Notifier;
import edu.colorado.phet.common.phetcommon.model.event.UpdateListener;
import edu.colorado.phet.common.piccolophet.nodes.kit.ZeroOffsetNode;
import edu.colorado.phet.lwjglphet.GLOptions;
import edu.colorado.phet.lwjglphet.PiccoloImage;
import edu.colorado.phet.lwjglphet.nodes.AbstractGraphicsNode;
import edu.colorado.phet.lwjglphet.utils.LWJGLUtils;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class ThreadedPlanarPiccoloNode
extends AbstractGraphicsNode {
    private final PNode node;
    private final PNode wrappedNode;
    private Cursor cursor = Cursor.getPredefinedCursor(0);
    private PiccoloImage piccoloImage;
    private List<Notifier<?>> repaintNotifiers = new ArrayList();
    private UpdateListener repaintListener = new UpdateListener(){

        public void update() {
            ThreadedPlanarPiccoloNode.this.repaint();
        }
    };

    public ThreadedPlanarPiccoloNode(PNode pNode) {
        this.node = pNode;
        this.wrappedNode = new ZeroOffsetNode(pNode);
        this.repaint();
    }

    public void repaint() {
        Dimension dimension = this.getCurrentSize();
        if (this.piccoloImage == null || !this.size.equals(dimension)) {
            this.size = dimension;
            this.rebuildComponentImage();
            this.onResize.updateListeners();
        }
        this.piccoloImage.repaint();
    }

    private Dimension getCurrentSize() {
        PBounds pBounds = this.node.getFullBounds();
        return new Dimension((int)Math.ceil(pBounds.getWidth()), (int)Math.ceil(pBounds.getHeight()));
    }

    public void renderSelf(GLOptions gLOptions) {
        if (this.piccoloImage == null) {
            return;
        }
        GL11.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glEnable(3553);
        GL11.glShadeModel(7424);
        this.piccoloImage.useTexture();
        GL11.glBegin(7);
        float f = 0.0f;
        float f2 = this.piccoloImage.getWidth();
        float f3 = this.size.height;
        float f4 = this.size.height - this.piccoloImage.getHeight();
        GL11.glTexCoord2f(0.0f, 1.0f);
        GL11.glVertex3f(f, f4, 0.0f);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex3f(f, f3, 0.0f);
        GL11.glTexCoord2f(1.0f, 0.0f);
        GL11.glVertex3f(f2, f3, 0.0f);
        GL11.glTexCoord2f(1.0f, 1.0f);
        GL11.glVertex3f(f2, f4, 0.0f);
        GL11.glEnd();
        GL11.glShadeModel(7425);
        GL11.glDisable(3553);
    }

    protected synchronized void rebuildComponentImage() {
        PiccoloImage piccoloImage;
        int n = LWJGLUtils.toPowerOf2(this.size.width);
        int n2 = LWJGLUtils.toPowerOf2(this.size.height);
        if (this.piccoloImage != null) {
            this.piccoloImage.dispose();
        }
        this.piccoloImage = piccoloImage = new PiccoloImage(n, n2, true, 9729, 9729, new AffineTransform(), this.wrappedNode);
    }

    public int getWidth() {
        return this.piccoloImage.getWidth();
    }

    public int getHeight() {
        return this.piccoloImage.getHeight();
    }
}

