/*
 * Decompiled with CFR 0.152.
 */
package Jama;

import Jama.LUDecomposition;
import java.io.Serializable;

public class Matrix
implements Serializable,
Cloneable {
    private double[][] A;
    private int m;
    private int n;

    public Matrix(int n, int n2) {
        this.m = n;
        this.n = n2;
        this.A = new double[n][n2];
    }

    public Matrix(double[][] dArray) {
        this.m = dArray.length;
        this.n = dArray[0].length;
        for (int i = 0; i < this.m; ++i) {
            if (dArray[i].length == this.n) continue;
            throw new IllegalArgumentException("All rows must have the same length.");
        }
        this.A = dArray;
    }

    public Matrix(double[][] dArray, int n, int n2) {
        this.A = dArray;
        this.m = n;
        this.n = n2;
    }

    public Matrix copy() {
        Matrix matrix = new Matrix(this.m, this.n);
        double[][] dArray = matrix.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = this.A[i][j];
            }
        }
        return matrix;
    }

    public Object clone() {
        return this.copy();
    }

    public double[][] getArray() {
        return this.A;
    }

    public double[][] getArrayCopy() {
        double[][] dArray = new double[this.m][this.n];
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = this.A[i][j];
            }
        }
        return dArray;
    }

    public int getRowDimension() {
        return this.m;
    }

    public int getColumnDimension() {
        return this.n;
    }

    public double get(int n, int n2) {
        return this.A[n][n2];
    }

    public void set(int n, int n2, double d) {
        this.A[n][n2] = d;
    }

    public Matrix transpose() {
        Matrix matrix = new Matrix(this.n, this.m);
        double[][] dArray = matrix.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[j][i] = this.A[i][j];
            }
        }
        return matrix;
    }

    public Matrix minus(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        Matrix matrix2 = new Matrix(this.m, this.n);
        double[][] dArray = matrix2.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = this.A[i][j] - matrix.A[i][j];
            }
        }
        return matrix2;
    }

    public Matrix arrayTimes(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        Matrix matrix2 = new Matrix(this.m, this.n);
        double[][] dArray = matrix2.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = this.A[i][j] * matrix.A[i][j];
            }
        }
        return matrix2;
    }

    public Matrix times(Matrix matrix) {
        if (matrix.m != this.n) {
            throw new IllegalArgumentException("Matrix inner dimensions must agree.");
        }
        Matrix matrix2 = new Matrix(this.m, matrix.n);
        double[][] dArray = matrix2.getArray();
        double[] dArray2 = new double[this.n];
        for (int i = 0; i < matrix.n; ++i) {
            int n;
            for (n = 0; n < this.n; ++n) {
                dArray2[n] = matrix.A[n][i];
            }
            for (n = 0; n < this.m; ++n) {
                double[] dArray3 = this.A[n];
                double d = 0.0;
                for (int j = 0; j < this.n; ++j) {
                    d += dArray3[j] * dArray2[j];
                }
                dArray[n][i] = d;
            }
        }
        return matrix2;
    }

    public double det() {
        return new LUDecomposition(this).det();
    }

    private void checkMatrixDimensions(Matrix matrix) {
        if (matrix.m != this.m || matrix.n != this.n) {
            throw new IllegalArgumentException("Matrix dimensions must agree.");
        }
    }
}

