/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.microwaves.view;

import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.microwaves.common.graphics.Graphic;
import edu.colorado.phet.microwaves.common.graphics.ImageGraphic;
import edu.colorado.phet.microwaves.model.Thermometer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;

public class ThermometerView
implements Graphic,
ImageObserver,
Observer {
    private BufferedImage thermometerBody;
    private BufferedImage thermometerBackground;
    private double temperature;
    private Point2D.Double modelLocation;
    private Point2D.Double viewLocation;
    private double[] keArray;
    private ImageGraphic backgroundGraphic;
    private ImageGraphic bodyGraphic;

    public ThermometerView(Thermometer thermometer) {
        this.viewLocation = this.modelLocation = new Point2D.Double(20.0, 50.0);
        this.keArray = new double[20];
        thermometer.addObserver(this);
        try {
            this.thermometerBody = ImageLoader.loadBufferedImage("microwaves/images/thermometer.png");
            this.bodyGraphic = new ImageGraphic(this.thermometerBody, this.modelLocation);
            this.thermometerBackground = ImageLoader.loadBufferedImage("microwaves/images/thermometer-background.png");
            this.backgroundGraphic = new ImageGraphic(this.thermometerBackground, this.modelLocation);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return false;
    }

    public void paint(Graphics2D graphics2D) {
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        this.backgroundGraphic.paint(graphics2D);
        graphics2D.setColor(Color.RED);
        double d = Math.min(this.temperature, (double)(this.thermometerBackground.getHeight() - 100));
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.viewLocation.x + 8.0, this.viewLocation.y + 50.0, 22.0, d);
        graphics2D.fill(double_);
        this.bodyGraphic.paint(graphics2D);
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof Thermometer) {
            double d = 0.0;
            for (int i = this.keArray.length - 2; i >= 0; --i) {
                double d2 = this.keArray[i];
                d += this.keArray[i];
                this.keArray[i + 1] = this.keArray[i];
            }
            this.keArray[0] = (Double)object * 5.0;
            this.temperature = (d += this.keArray[0]) / 20.0;
        }
        this.viewLocation = this.modelLocation;
    }
}

