/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.microwaves.model.waves;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.microwaves.model.waves.PeriodicFunction;
import edu.colorado.phet.microwaves.model.waves.WavefrontType;
import java.util.Observable;

public class Wave
extends Observable
implements ModelElement {
    private PeriodicFunction waveFunction;
    private WavefrontType wavefrontType;
    private float maxAmplitude;
    private float frequency;
    private float[] amplitude = new float[s_length];
    private float[] frequencyAtTime = new float[s_length];
    private float[] maxAmplitudeAtTime = new float[s_length];
    private float[] prevFrequencyAtTime = new float[s_length];
    private float[] prevMaxAmplitudeAtTime = new float[s_length];
    private float time = 0.0f;
    private int propagationSpeed = 10;
    private boolean enabled = true;
    public static int s_length = 1000;

    public Wave(WavefrontType wavefrontType, PeriodicFunction periodicFunction, float f, float f2) {
        this.wavefrontType = wavefrontType;
        this.waveFunction = periodicFunction;
        this.frequency = f;
        this.maxAmplitude = f2;
    }

    public void stepInTime(double d) {
        int n;
        this.time = (float)((double)this.time + d);
        int n2 = this.propagationSpeed;
        for (n = s_length - 1; n > n2 - 1; --n) {
            this.prevMaxAmplitudeAtTime[n] = this.maxAmplitudeAtTime[n];
            this.amplitude[n] = this.amplitude[n - n2];
            this.amplitude[n] = this.wavefrontType.computeAmplitudeAtDistance(this, this.amplitude[n], n);
            this.prevFrequencyAtTime[n] = this.frequencyAtTime[n];
            this.frequencyAtTime[n] = this.frequencyAtTime[n - n2];
            this.maxAmplitudeAtTime[n] = this.maxAmplitudeAtTime[n - n2];
            this.maxAmplitudeAtTime[n] = this.wavefrontType.computeAmplitudeAtDistance(this, this.maxAmplitudeAtTime[n], n);
        }
        for (n = 0; n < n2; ++n) {
            this.amplitude[n] = this.waveFunction.valueAtTime(this.frequency, this.maxAmplitude, this.time);
            if (this.frequencyAtTime[n] != this.frequency) {
                this.frequencyAtTime[n] = this.frequency;
            }
            if (this.maxAmplitudeAtTime[n] == this.maxAmplitude) continue;
            this.maxAmplitudeAtTime[n] = this.maxAmplitude;
        }
        this.setChanged();
        this.notifyObservers();
    }

    public float[] getAmplitude() {
        return this.amplitude;
    }

    public void setMaxAmplitude(float f) {
        this.maxAmplitude = f;
        this.setChanged();
        this.notifyObservers();
    }

    public void setFrequency(float f) {
        if (f != 0.0f) {
            double d = this.time * (this.frequency / f - 1.0f);
            this.time += (float)d;
        }
        this.frequency = f;
        this.setChanged();
        this.notifyObservers();
    }
}

