/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.microwaves.coreadditions.collision;

import edu.colorado.phet.microwaves.coreadditions.Body;
import edu.colorado.phet.microwaves.coreadditions.Vector2D;
import java.awt.geom.Point2D;

public class Wall
extends Body {
    private Point2D.Float end1;
    private Point2D.Float end2;
    private Point2D.Double cm = new Point2D.Double();
    private Vector2D loaUnit;

    protected Wall() {
        this.init();
    }

    private void init() {
        this.setVelocity(0.0f, 0.0f);
        this.setVelocity(0.0f, 0.0f);
        this.setMass(Double.POSITIVE_INFINITY);
    }

    protected void setLocation(Point2D.Float float_, Point2D.Float float_2) {
        this.end1 = float_;
        this.end2 = float_2;
        this.setLoaUnit();
        this.setChanged();
        this.notifyObservers();
    }

    public void setLocation(double d, double d2, double d3, double d4) {
        this.end1.setLocation(d, d3);
        this.end2.setLocation(d2, d4);
        this.setChanged();
        this.notifyObservers();
    }

    private void setLoaUnit() {
        this.loaUnit = new Vector2D((float)(this.end2.getY() - this.end1.getY()), (float)(this.end2.getX() - this.end1.getX())).normalize();
    }

    public Point2D.Double getCM() {
        this.cm.setLocation((this.end1.getX() + this.end2.getX()) / 2.0, (this.end1.getY() + this.end2.getY()) / 2.0);
        return this.cm;
    }

    public double getMomentOfInertia() {
        return Double.POSITIVE_INFINITY;
    }
}

