/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.view.monitors;

import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.common.phetcommon.util.SimpleObservable;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.graphics.mousecontrols.translation.TranslationEvent;
import edu.colorado.phet.common.phetgraphics.view.graphics.mousecontrols.translation.TranslationListener;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.idealgas.IdealGasResources;
import edu.colorado.phet.idealgas.model.Box2D;
import edu.colorado.phet.idealgas.model.PressureSensingBox;
import edu.colorado.phet.idealgas.model.PressureSlice;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.EventListener;
import java.util.EventObject;

public class PressureSliceGraphic
extends CompositePhetGraphic
implements Box2D.ChangeListener,
PressureSensingBox.ChangeListener {
    private float s_overlayTransparency = 0.3f;
    private double y;
    private Rectangle2D.Double boundingRect = new Rectangle2D.Double();
    private RoundRectangle2D.Double readoutRectangle = new RoundRectangle2D.Double();
    private Stroke pressureSliceStroke = new BasicStroke();
    private int pressureSliceHeight = 10;
    private double boxLeftEdge;
    private double boxLowerEdge;
    private double boxRightEdge;
    private PressureSensingBox box;
    private PressureSlice pressureSlice;
    private SimpleObservable pressureReadingSource;
    private NumberFormat temperatureFormatter = new DecimalFormat("#");
    private NumberFormat pressureFormatter = new DecimalFormat("0.00");
    private NumberFormat heightFormatter = new DecimalFormat("0.00");
    private double temperature;
    private double pressure;
    private Font font = new PhetFont(1, 12);
    private InternalGraphic internalGraphic;
    private Area drawingArea = new Area();
    private boolean displayTemperature;
    private EventChannel channel = new EventChannel(Listener.class);
    private Listener listenerProxy = (Listener)this.channel.getListenerProxy();

    public PressureSliceGraphic(Component component, final PressureSlice pressureSlice, final PressureSensingBox pressureSensingBox) {
        super(component);
        this.pressureSlice = pressureSlice;
        this.pressureReadingSource = pressureSensingBox;
        pressureSensingBox.addChangeListener(this);
        pressureSensingBox.addChangeListener(this);
        this.internalGraphic = new InternalGraphic(component);
        this.setCursorHand();
        this.addTranslationListener(new TranslationListener(){

            public void translationOccurred(TranslationEvent translationEvent) {
                double d = 4.54;
                double d2 = Math.min(pressureSensingBox.getMaxY() - d, Math.max(PressureSliceGraphic.this.y + (double)translationEvent.getDy(), pressureSensingBox.getMinY() + d));
                PressureSliceGraphic.this.y = d2;
                pressureSlice.setY(PressureSliceGraphic.this.y);
                PressureSliceGraphic.this.listenerProxy.moved(new Event(PressureSliceGraphic.this));
                PressureSliceGraphic.this.internalGraphic.update();
            }
        });
        this.box = pressureSensingBox;
        this.y = pressureSensingBox.getMinY() + (pressureSensingBox.getMaxY() - pressureSensingBox.getMinY()) / 2.0;
        pressureSlice.setY(this.y);
    }

    protected PhetGraphic getHandler(Point point) {
        if (this.isVisible() && this.drawingArea.contains(point)) {
            return this;
        }
        return null;
    }

    protected Rectangle determineBounds() {
        return this.internalGraphic.getBounds();
    }

    public void paint(Graphics2D graphics2D) {
        this.internalGraphic.paint(graphics2D);
    }

    public void stateChanged(PressureSensingBox.ChangeEvent changeEvent) {
        PressureSensingBox pressureSensingBox = changeEvent.getPressureSensingBox();
        this.pressureReadingSource = pressureSensingBox.getMultipleSlicesEnabled() ? pressureSensingBox : this.pressureSlice;
    }

    public void boundsChanged(Box2D.ChangeEvent changeEvent) {
        this.internalGraphic.update();
    }

    public void isVolumeFixedChanged(Box2D.ChangeEvent changeEvent) {
    }

    public class Event
    extends EventObject {
        public Event(Object object) {
            super(object);
        }
    }

    private class InternalGraphic
    extends PhetShapeGraphic
    implements SimpleObserver {
        InternalGraphic(Component component) {
            super(component, null, null);
            this.setShape(PressureSliceGraphic.this.drawingArea);
            PressureSliceGraphic.this.pressureSlice.addObserver(this);
            this.update();
        }

        public boolean contains(int n, int n2) {
            return PressureSliceGraphic.this.boundingRect.contains(n, n2) || PressureSliceGraphic.this.readoutRectangle.contains(n, n2);
        }

        public void update() {
            if (PressureSliceGraphic.this.pressureReadingSource == PressureSliceGraphic.this.box) {
                PressureSliceGraphic.this.pressure = PressureSliceGraphic.this.box.getPressure();
            } else {
                PressureSliceGraphic.this.pressure = PressureSliceGraphic.this.pressureSlice.getPressure();
            }
            PressureSliceGraphic.this.temperature = PressureSliceGraphic.this.pressureSlice.getTemperature();
            PressureSliceGraphic.this.drawingArea.exclusiveOr(PressureSliceGraphic.this.drawingArea);
            PressureSliceGraphic.this.drawingArea.add(new Area(PressureSliceGraphic.this.boundingRect));
            PressureSliceGraphic.this.drawingArea.add(new Area(new Rectangle((int)PressureSliceGraphic.this.readoutRectangle.getX() - 2, (int)PressureSliceGraphic.this.readoutRectangle.getY() - 2, (int)PressureSliceGraphic.this.readoutRectangle.getWidth() + 4, (int)PressureSliceGraphic.this.readoutRectangle.getHeight() + 4)));
            this.setBoundsDirty();
            this.repaint();
        }

        public void paint(Graphics2D graphics2D) {
            this.saveGraphicsState(graphics2D);
            graphics2D.setFont(PressureSliceGraphic.this.font);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n = 117;
            int n2 = 8;
            int n3 = PressureSliceGraphic.this.displayTemperature ? 3 : 2;
            int n4 = fontMetrics.getHeight() * n3 + fontMetrics.getMaxDescent();
            graphics2D.setStroke(PressureSliceGraphic.this.pressureSliceStroke);
            PressureSliceGraphic.this.boxLeftEdge = PressureSliceGraphic.this.box.getMinX();
            PressureSliceGraphic.this.boxRightEdge = PressureSliceGraphic.this.box.getMaxX();
            PressureSliceGraphic.this.boxLowerEdge = PressureSliceGraphic.this.box.getMaxY();
            PressureSliceGraphic.this.boundingRect.setRect(PressureSliceGraphic.this.boxLeftEdge, PressureSliceGraphic.this.y - (double)(PressureSliceGraphic.this.pressureSliceHeight / 2), PressureSliceGraphic.this.boxRightEdge - PressureSliceGraphic.this.boxLeftEdge, PressureSliceGraphic.this.pressureSliceHeight);
            PressureSliceGraphic.this.readoutRectangle.setRoundRect((int)PressureSliceGraphic.this.boundingRect.getMinX() - (n + n2 * 2), (int)PressureSliceGraphic.this.boundingRect.getMinY() - n4 / 2 - n2, n + n2 * 2, n4 + 2 * n2, 10.0, 10.0);
            graphics2D.setColor(Color.YELLOW);
            graphics2D.setComposite(AlphaComposite.getInstance(3, PressureSliceGraphic.this.s_overlayTransparency));
            graphics2D.fill(PressureSliceGraphic.this.boundingRect);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            graphics2D.draw(PressureSliceGraphic.this.boundingRect);
            graphics2D.setComposite(AlphaComposite.getInstance(3, PressureSliceGraphic.this.s_overlayTransparency));
            graphics2D.fill(PressureSliceGraphic.this.readoutRectangle);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            graphics2D.draw(PressureSliceGraphic.this.readoutRectangle);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Point point = new Point((int)(PressureSliceGraphic.this.readoutRectangle.getMinX() + (double)n2), (int)(PressureSliceGraphic.this.readoutRectangle.getMinY() + (double)n2));
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            graphics2D.drawRoundRect(point.x, point.y, n, n4, 5, 5);
            graphics2D.setColor(Color.WHITE);
            graphics2D.setComposite(AlphaComposite.getInstance(2, PressureSliceGraphic.this.s_overlayTransparency));
            graphics2D.fillRect(point.x, point.y, n, n4);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            graphics2D.setColor(Color.yellow);
            graphics2D.drawRoundRect(point.x, point.y, n, n4, 5, 5);
            int n5 = point.y + fontMetrics.getAscent() / 2;
            String string = "P = " + PressureSliceGraphic.this.pressureFormatter.format(PressureSliceGraphic.this.pressure) + " " + IdealGasResources.getString("pressure-gauge.units");
            graphics2D.setColor(Color.black);
            graphics2D.drawString(string, point.x + 5, n5 += n2);
            if (PressureSliceGraphic.this.displayTemperature) {
                if (Double.isInfinite(PressureSliceGraphic.this.temperature) || Double.isNaN(PressureSliceGraphic.this.temperature)) {
                    PressureSliceGraphic.this.temperature = 0.0;
                }
                String string2 = "T = " + PressureSliceGraphic.this.temperatureFormatter.format(PressureSliceGraphic.this.temperature) + " K";
                graphics2D.setColor(Color.black);
                graphics2D.drawString(string2, point.x + 5, n5 += fontMetrics.getHeight());
            }
            double d = (PressureSliceGraphic.this.boxLowerEdge - PressureSliceGraphic.this.y) / 45.4;
            String string3 = IdealGasResources.getString("PressureSlideGraphic.height") + " = " + PressureSliceGraphic.this.heightFormatter.format(d) + "nm";
            graphics2D.setColor(Color.black);
            graphics2D.drawString(string3, point.x + 5, n5 += fontMetrics.getHeight());
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            this.restoreGraphicsState();
        }
    }

    public static interface Listener
    extends EventListener {
        public void moved(Event var1);
    }
}

