/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.FrameSequence;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.idealgas.model.IdealGasModel;
import edu.colorado.phet.idealgas.model.PressureSensingBox;
import edu.colorado.phet.idealgas.view.Box2DGraphic;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;

public class Mannequin
extends PhetGraphic
implements SimpleObserver {
    private static float s_leaningManStateChangeScaleFactor = 1.75f;
    private FrameSequence pusher;
    private FrameSequence leaner;
    private Image currPusherFrame;
    private Image currLeanerFrame;
    private IdealGasModel model;
    private PressureSensingBox box;
    private Box2DGraphic boxGraphic;
    private Point location = new Point();
    private double lastPressure;
    private Image currFrame;

    public Mannequin(Component component, IdealGasModel idealGasModel, PressureSensingBox pressureSensingBox, Box2DGraphic box2DGraphic) {
        super(component);
        this.model = idealGasModel;
        this.box = pressureSensingBox;
        this.boxGraphic = box2DGraphic;
        try {
            this.pusher = new FrameSequence("ideal-gas/images/animations/pusher-light-w-tank/pusher-3-light-w-tank", "png", 19);
            this.leaner = new FrameSequence("ideal-gas/images/animations/pusher-leaning-light-w-tank/pusher-leaning-light-w-tank", "png", 15);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.currPusherFrame = this.pusher.getCurrFrame();
        this.currLeanerFrame = this.leaner.getCurrFrame();
        pressureSensingBox.addObserver(this);
        this.update();
        super.setIgnoreMouse(true);
    }

    protected Rectangle determineBounds() {
        return new Rectangle(this.location.x, this.location.y, this.currPusherFrame.getWidth(null), this.currPusherFrame.getHeight(null));
    }

    public void paint(Graphics2D graphics2D) {
        graphics2D.drawImage(this.currFrame, this.location.x, this.location.y, null);
    }

    public void update() {
        boolean bl;
        int n = -((int)Box2DGraphic.s_thickness) + 3;
        int n2 = (int)Box2DGraphic.s_thickness;
        int n3 = (int)this.box.getMinX() - this.currPusherFrame.getHeight(null) + n;
        boolean bl2 = bl = n3 != this.location.x;
        if (bl || this.boxGraphic.isGraphicSelected()) {
            int n4 = n3 - this.location.x;
            this.location.setLocation((double)n3, this.box.getMaxY() - (double)this.currPusherFrame.getWidth(null) + (double)n2);
            if (bl) {
                this.currPusherFrame = n4 > 0 ? this.pusher.getNextFrame() : this.pusher.getPrevFrame();
            }
            this.currFrame = this.currPusherFrame;
            this.setBoundsDirty();
            this.repaint();
        } else {
            double d = this.box.getPressure();
            if (d != this.lastPressure) {
                int n5 = d == this.lastPressure ? 0 : (d > this.lastPressure * (double)s_leaningManStateChangeScaleFactor ? 1 : -1);
                this.lastPressure = d;
                if (n5 > 0 && this.leaner.getCurrFrameNum() + 1 < this.leaner.getNumFrames()) {
                    this.currLeanerFrame = this.leaner.getNextFrame();
                } else if (n5 < 0 && this.leaner.getCurrFrameNum() > 0) {
                    this.currLeanerFrame = this.leaner.getPrevFrame();
                }
                int n6 = (int)Math.min(d / 6.0 * (double)this.leaner.getNumFrames(), (double)(this.leaner.getNumFrames() - 1));
                this.currLeanerFrame = this.leaner.getFrame(n6);
                if (this.model.isConstantVolume() || this.model.isConstantNone()) {
                    this.currFrame = this.currLeanerFrame;
                    this.setBoundsDirty();
                    this.repaint();
                }
            }
        }
    }
}

