/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.model;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.idealgas.collision.CollidableBody;
import edu.colorado.phet.idealgas.model.Box2D;
import edu.colorado.phet.idealgas.model.HollowSphere;
import java.awt.geom.Point2D;

public class Balloon
extends HollowSphere {
    private int timeStepsSinceLastRadiusAdjustment = 0;
    private int timeStepsBetweenRadiusAdjustments = 5;
    private double dampingExponent = 0.02;
    private MutableVector2D momentumPre = new MutableVector2D();
    private MutableVector2D momentumPost = new MutableVector2D();
    private Box2D box;
    private double accumulatedImpact = 0.0;

    public Balloon(Point2D point2D, MutableVector2D mutableVector2D, MutableVector2D mutableVector2D2, double d, double d2, Box2D box2D) {
        super(point2D, mutableVector2D, mutableVector2D2, d, d2);
        this.box = box2D;
    }

    public void collideWithParticle(CollidableBody collidableBody) {
        this.momentumPost.setX(this.getVelocity().getX());
        this.momentumPost.setY(this.getVelocity().getY());
        this.momentumPost = this.momentumPost.scale(this.getMass());
        MutableVector2D mutableVector2D = this.momentumPost.subtract(this.momentumPre);
        double d = mutableVector2D.magnitude();
        int n = this.contains(collidableBody) ? 1 : -1;
        this.accumulatedImpact += d * (double)n;
        this.momentumPre.setComponents(this.momentumPost.getX(), this.momentumPost.getY());
        if (this.timeStepsSinceLastRadiusAdjustment >= this.timeStepsBetweenRadiusAdjustments) {
            this.adjustRadius();
            this.accumulatedImpact = 0.0;
            this.timeStepsSinceLastRadiusAdjustment = 0;
        }
        super.collideWithParticle(collidableBody);
    }

    private void adjustRadius() {
        double d = 0.99 * Math.min((this.box.getMaxX() - this.box.getMinX()) / 2.0, (this.box.getMaxY() - this.box.getMinY()) / 2.0);
        double d2 = Math.pow(Math.abs(this.accumulatedImpact), this.dampingExponent) * (double)MathUtil.getSign(this.accumulatedImpact);
        double d3 = Math.min(this.getRadius() + d2, d);
        if (!Double.isNaN(d3)) {
            d3 = Math.min(d, Math.max(d3, 10.0));
            this.setRadius(d3);
        }
    }

    public void stepInTime(double d) {
        super.stepInTime(d);
        ++this.timeStepsSinceLastRadiusAdjustment;
    }
}

