/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.model.components;

import edu.colorado.phet.circuitconstructionkit.model.CircuitChangeListener;
import edu.colorado.phet.circuitconstructionkit.model.DynamicBranch;
import edu.colorado.phet.circuitconstructionkit.model.Junction;
import edu.colorado.phet.circuitconstructionkit.model.components.CircuitComponent;
import java.util.ArrayList;

public class Capacitor
extends CircuitComponent
implements DynamicBranch {
    private double capacitance = 0.1;
    private ArrayList listeners = new ArrayList();

    public Capacitor(CircuitChangeListener circuitChangeListener, Junction junction, Junction junction2, double d, double d2) {
        super(circuitChangeListener, junction, junction2, d, d2);
    }

    public double getCapacitance() {
        return this.capacitance;
    }

    public void setCapacitance(double d) {
        this.capacitance = d;
        this.notifyObservers();
        this.fireKirkhoffChange();
        this.notifyChargeChanged();
    }

    public void setCapacitanceConstantCharge(double d) {
        double d2 = this.getCharge();
        this.setCapacitance(d);
        this.setVoltageDrop(d2 / d);
        this.notifyObservers();
        this.fireKirkhoffChange();
        this.notifyChargeChanged();
    }

    public void setVoltageDrop(double d) {
        super.setVoltageDrop(d);
        this.notifyChargeChanged();
    }

    public void stepInTime(double d) {
    }

    public void resetDynamics() {
        this.setKirkhoffEnabled(false);
        this.setVoltageDrop(0.0);
        this.setCurrent(0.0);
        this.setMNACurrent(0.0);
        this.setMNAVoltageDrop(0.0);
        this.setKirkhoffEnabled(true);
    }

    public double getCharge() {
        return this.getCapacitance() * this.getVoltageDrop();
    }

    public void notifyChargeChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.chargeChanged();
        }
    }

    public static interface Listener {
        public void chargeChanged();
    }
}

