/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.chart;

import edu.colorado.phet.circuitconstructionkit.view.chart.AbstractFloatingChart;
import edu.colorado.phet.circuitconstructionkit.view.chart.StripChartJFCNode;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class CrosshairNode
extends PComposite {
    private static final Paint CROSSHAIR_COLOR = Color.white;
    private BasicStroke CROSSHAIR_STROKE = new BasicStroke(2.0f);
    private CrosshairDragHandler listener;
    private AbstractFloatingChart intensityReader;
    private boolean attached = false;
    private Vector2D originalDisplacement;
    private PPath background;
    private PPath innerCircle;

    public CrosshairNode(AbstractFloatingChart abstractFloatingChart, int n, int n2) {
        this.intensityReader = abstractFloatingChart;
        Ellipse2D.Double double_ = new Ellipse2D.Double(-n, -n, n * 2, n * 2);
        this.innerCircle = new PPath(double_);
        this.innerCircle.setStrokePaint(Color.darkGray);
        this.innerCircle.setStroke(new BasicStroke(1.0f));
        PPath pPath = new PPath(new Line2D.Double(0.0, -n2, 0.0, n2));
        pPath.setStroke(this.CROSSHAIR_STROKE);
        pPath.setStrokePaint(CROSSHAIR_COLOR);
        PPath pPath2 = new PPath(new Line2D.Double(-n2, 0.0, n2, 0.0));
        pPath2.setStroke(this.CROSSHAIR_STROKE);
        pPath2.setStrokePaint(CROSSHAIR_COLOR);
        Area area = new Area();
        area.add(new Area(new Rectangle2D.Double(-n2, -n2, n2 * 2, n2 * 2)));
        area.subtract(new Area(double_));
        this.background = new PPath(area);
        this.background.setPaint(Color.lightGray);
        this.background.setStrokePaint(Color.gray);
        this.addChild(this.background);
        this.addChild(this.innerCircle);
        this.addChild(pPath);
        this.addChild(pPath2);
        PPath pPath3 = new PPath(new Rectangle2D.Double(-n2, -n2, n2 * 2, n2 * 2));
        pPath3.setPaint(new Color(255, 255, 255, 0));
        pPath3.setStrokePaint(new Color(255, 255, 255, 0));
        this.addChild(pPath3);
        this.listener = new CrosshairDragHandler();
        this.addInputEventListener(this.listener);
        this.originalDisplacement = this.getDisplacement();
    }

    public StripChartJFCNode getStripChartJFCNode() {
        return this.intensityReader.getStripChartJFCNode();
    }

    private void attachCrosshair() {
        this.attached = true;
        this.setOffset(this.getStripChartJFCNode().getFullBounds().getCenterX() + this.originalDisplacement.getX() - this.getFullBounds().getWidth() / 2.0, this.getStripChartJFCNode().getFullBounds().getCenterY() + this.originalDisplacement.getY());
    }

    private Vector2D getDisplacement() {
        return new Vector2D(this.getStripChartJFCNode().getFullBounds().getCenter2D(), this.getFullBounds().getCenter2D());
    }

    private void crosshairDropped() {
        double d = 30.0;
        if (MathUtil.isApproxEqual(this.getDisplacement().getX(), this.originalDisplacement.getX(), d) && MathUtil.isApproxEqual(this.getDisplacement().getY(), this.originalDisplacement.getY(), d)) {
            this.attachCrosshair();
        }
    }

    private void detachCrosshair() {
        this.attached = false;
    }

    public boolean isAttached() {
        return this.attached;
    }

    public void setColor(Color color) {
        this.background.setPaint(color);
        this.innerCircle.setStrokePaint(Color.gray);
    }

    class CrosshairDragHandler
    extends PDragEventHandler {
        CrosshairDragHandler() {
        }

        protected void drag(PInputEvent pInputEvent) {
            super.drag(pInputEvent);
            CrosshairNode.this.detachCrosshair();
            pInputEvent.setHandled(true);
        }

        protected void endDrag(PInputEvent pInputEvent) {
            super.endDrag(pInputEvent);
            CrosshairNode.this.crosshairDropped();
        }
    }
}

