/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.controls;

import edu.colorado.phet.circuitconstructionkit.CCKModule;
import edu.colorado.phet.circuitconstructionkit.CCKResources;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.circuitconstructionkit.model.components.Resistor;
import edu.colorado.phet.circuitconstructionkit.model.grabbag.GrabBag;
import edu.colorado.phet.circuitconstructionkit.model.grabbag.GrabBagItem;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class GrabBagButton
extends JButton {
    private GrabBag bag;
    private CCKModule module;
    private JFrame dialog;

    public GrabBagButton(CCKModule cCKModule) {
        super(CCKResources.getString("GrabBagButton.ButtonTitle"));
        try {
            this.setIcon(new ImageIcon(BufferedImageUtils.rescaleYMaintainAspectRatio(ImageLoader.loadBufferedImage("circuit-construction-kit/images/bag.gif"), 45)));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.module = cCKModule;
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GrabBagButton.this.showGrabBag();
            }
        });
        this.bag = new GrabBag();
        this.dialog = new JFrame(CCKResources.getString("GrabBagButton.DialogTitle"));
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        verticalLayoutPanel.setAnchor(10);
        verticalLayoutPanel.setFill(0);
        JLabel jLabel = new JLabel(CCKResources.getString("GrabBagButton.Help"));
        verticalLayoutPanel.add(jLabel);
        JLabel jLabel2 = new JLabel(" ");
        verticalLayoutPanel.add(jLabel2);
        this.dialog.setContentPane(verticalLayoutPanel);
        for (int i = 0; i < this.bag.numItems(); ++i) {
            final GrabBagItem grabBagItem = this.bag.itemAt(i);
            BufferedImage bufferedImage = grabBagItem.getImage();
            BufferedImage bufferedImage2 = BufferedImageUtils.rescaleYMaintainAspectRatio(bufferedImage, 40);
            ImageIcon imageIcon = new ImageIcon(bufferedImage2);
            JButton jButton = new JButton(grabBagItem.getName());
            JPanel jPanel = new JPanel();
            jPanel.add(new JLabel(imageIcon));
            jPanel.add(jButton);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GrabBagButton.this.showItem(grabBagItem);
                }
            });
            SwingUtilities.updateComponentTreeUI(jButton);
            verticalLayoutPanel.add(jPanel);
        }
        this.dialog.pack();
        SwingUtilities.updateComponentTreeUI(this.dialog);
        SwingUtils.centerWindowOnScreen(this.dialog);
        this.dialog.pack();
    }

    private void showItem(GrabBagItem grabBagItem) {
        this.dialog.setVisible(false);
        Resistor resistor = grabBagItem.createBranch(this.module);
        this.module.getCircuit().addBranch(resistor);
        this.module.layoutElectrons(new Branch[]{resistor});
        this.module.getSimulationPanel().repaint();
    }

    private void showGrabBag() {
        this.dialog.setVisible(true);
    }
}

