/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.view;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.ArrowNode;
import edu.colorado.phet.common.piccolophet.nodes.DoubleArrowNode;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsResources;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.common.model.AtomicNucleus;
import edu.colorado.phet.nuclearphysics.model.DaughterCompositeNucleus;
import edu.colorado.phet.nuclearphysics.module.fissiononenucleus.FissionOneNucleusModel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.nodes.PComposite;
import edu.umd.cs.piccolox.nodes.PLine;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Random;

public class FissionEnergyChart
extends PComposite {
    private static final Color BORDER_COLOR = Color.DARK_GRAY;
    private static final Stroke BORDER_STROKE = new BasicStroke(8.0f);
    private static final Color BACKGROUND_COLOR = Color.WHITE;
    private static final Color AXES_LINE_COLOR = Color.GRAY;
    private static final Stroke ENERGY_LINE_STROKE = new BasicStroke(2.0f);
    private static final Color TOTAL_ENERGY_LINE_COLOR = Color.ORANGE;
    private static final Color POTENTIAL_ENERGY_LINE_COLOR = Color.BLUE;
    private static final Color LEGEND_BORDER_COLOR = Color.GRAY;
    private static final Stroke LEGEND_BORDER_STROKE = new BasicStroke(4.0f);
    private static final Color LEGEND_BACKGROUND_COLOR = new Color(0xFFFFE0);
    private static final Stroke TICK_MARK_STROKE = new BasicStroke(2.0f);
    private static final Font TICK_MARK_LABEL_FONT = new PhetFont(0, 12);
    private static final Color TICK_MARK_COLOR = AXES_LINE_COLOR;
    private PPath _borderNode;
    private PLine _totalEnergyLine;
    private PPath _potentialEnergyWell;
    private DoubleArrowNode _xAxisOfGraph;
    private ArrowNode _yAxisOfGraph;
    private PText _yAxisLabelHigh;
    private PText _yAxisLabelLow;
    private PText _xAxisLabel;
    private PPath _legend;
    private PText _potentialEnergyLabel;
    private PText _totalEnergyLabel;
    private PLine _potentialEnergyLegendLine;
    private PLine _totalEnergyLegendLine;
    private PNode _unfissionedNucleusImage;
    private PNode _largerDaughterNucleusImage;
    private PNode _smallerDaughterNucleusImage;
    private PPath _xAxisTickMark;
    private PText _xAxisTickMarkLabel;
    double _usableAreaOriginX;
    double _usableAreaOriginY;
    double _usableWidth;
    double _usableHeight;
    double _graphOriginX;
    double _graphOriginY;
    double _energyWellWidth;
    private FissionOneNucleusModel _model;
    private PhetPCanvas _canvas;
    private int _fissionState = 0;
    private int _origNumNeturons;
    Random _rand = new Random();
    DaughterCompositeNucleus _daughterNucleus;

    public FissionEnergyChart(FissionOneNucleusModel fissionOneNucleusModel, PhetPCanvas phetPCanvas) {
        this._model = fissionOneNucleusModel;
        this._canvas = phetPCanvas;
        this._origNumNeturons = this._model.getAtomicNucleus().getNumNeutrons();
        this.setPickable(false);
        this._model.getClock().addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                FissionEnergyChart.this.handleClockTicked(clockEvent);
            }

            public void simulationTimeReset(ClockEvent clockEvent) {
            }
        });
        this._model.getAtomicNucleus().addListener(new AtomicNucleus.Adapter(){

            public void nucleusChangeEvent(AtomicNucleus atomicNucleus, int n, int n2, ArrayList arrayList) {
                if (arrayList != null) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        if (!(arrayList.get(i) instanceof DaughterCompositeNucleus)) continue;
                        FissionEnergyChart.this._daughterNucleus = (DaughterCompositeNucleus)arrayList.get(i);
                    }
                    assert (FissionEnergyChart.this._daughterNucleus != null);
                    FissionEnergyChart.this._fissionState = 2;
                    FissionEnergyChart.this._unfissionedNucleusImage.setVisible(false);
                    FissionEnergyChart.this._largerDaughterNucleusImage.setVisible(true);
                    FissionEnergyChart.this._smallerDaughterNucleusImage.setVisible(true);
                    FissionEnergyChart.this.updateNucleiPositions();
                } else if (n2 > FissionEnergyChart.this._origNumNeturons) {
                    FissionEnergyChart.this._fissionState = 1;
                    FissionEnergyChart.this.updateNucleiPositions();
                } else if (n2 == FissionEnergyChart.this._origNumNeturons) {
                    FissionEnergyChart.this._fissionState = 0;
                    FissionEnergyChart.this._daughterNucleus = null;
                    FissionEnergyChart.this._unfissionedNucleusImage.setVisible(true);
                    FissionEnergyChart.this._largerDaughterNucleusImage.setVisible(false);
                    FissionEnergyChart.this._smallerDaughterNucleusImage.setVisible(false);
                    FissionEnergyChart.this.updateNucleiPositions();
                } else {
                    System.err.println("Error: Unable to interpret decay event.");
                    assert (false);
                }
            }
        });
        this._borderNode = new PPath();
        this._borderNode.setStroke(BORDER_STROKE);
        this._borderNode.setStrokePaint(BORDER_COLOR);
        this._borderNode.setPaint(BACKGROUND_COLOR);
        this.addChild(this._borderNode);
        this._xAxisOfGraph = new DoubleArrowNode(new Point2D.Double(0.0, 0.0), new Point2D.Double(100.0, 100.0), 9.0, 7.0, 1.0);
        this._xAxisOfGraph.setPaint(AXES_LINE_COLOR);
        this._xAxisOfGraph.setStrokePaint(AXES_LINE_COLOR);
        this.addChild(this._xAxisOfGraph);
        this._yAxisOfGraph = new ArrowNode(new Point2D.Double(0.0, 0.0), new Point2D.Double(100.0, 100.0), 9.0, 7.0, 1.0);
        this._yAxisOfGraph.setPaint(AXES_LINE_COLOR);
        this._yAxisOfGraph.setStrokePaint(AXES_LINE_COLOR);
        this.addChild(this._yAxisOfGraph);
        this._totalEnergyLine = new PLine();
        this._totalEnergyLine.setStrokePaint(TOTAL_ENERGY_LINE_COLOR);
        this._totalEnergyLine.setStroke(ENERGY_LINE_STROKE);
        this.addChild(this._totalEnergyLine);
        this._potentialEnergyWell = new PPath(){

            public void paint(PPaintContext pPaintContext) {
                Graphics2D graphics2D = pPaintContext.getGraphics();
                RenderingHints renderingHints = graphics2D.getRenderingHints();
                graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                super.paint(pPaintContext);
                graphics2D.setRenderingHints(renderingHints);
            }
        };
        this._potentialEnergyWell.setStrokePaint(POTENTIAL_ENERGY_LINE_COLOR);
        this._potentialEnergyWell.setStroke(ENERGY_LINE_STROKE);
        this.addChild(this._potentialEnergyWell);
        this._yAxisLabelHigh = new PText(NuclearPhysicsStrings.POTENTIAL_PROFILE_Y_AXIS_LABEL_3);
        this._yAxisLabelHigh.setFont(new PhetFont(0, 14));
        this._yAxisLabelHigh.rotate(4.71238898038469);
        this.addChild(this._yAxisLabelHigh);
        this._yAxisLabelLow = new PText(NuclearPhysicsStrings.POTENTIAL_PROFILE_Y_AXIS_LABEL_4);
        this._yAxisLabelLow.setFont(new PhetFont(0, 14));
        this._yAxisLabelLow.rotate(4.71238898038469);
        this.addChild(this._yAxisLabelLow);
        this._xAxisLabel = new PText(NuclearPhysicsStrings.POTENTIAL_PROFILE_X_AXIS_LABEL);
        this._xAxisLabel.setFont(new PhetFont(0, 14));
        this.addChild(this._xAxisLabel);
        this._xAxisTickMark = new PPath();
        this._xAxisTickMark.setStroke(TICK_MARK_STROKE);
        this._xAxisTickMark.setStrokePaint(TICK_MARK_COLOR);
        this.addChild(this._xAxisTickMark);
        this._xAxisTickMarkLabel = new PText("0");
        this._xAxisTickMarkLabel.setFont(TICK_MARK_LABEL_FONT);
        this.addChild(this._xAxisTickMarkLabel);
        this._legend = new PPath();
        this._legend.setStroke(LEGEND_BORDER_STROKE);
        this._legend.setStrokePaint(LEGEND_BORDER_COLOR);
        this._legend.setPaint(LEGEND_BACKGROUND_COLOR);
        this.addChild(this._legend);
        this._potentialEnergyLegendLine = new PLine();
        this._potentialEnergyLegendLine.setStrokePaint(POTENTIAL_ENERGY_LINE_COLOR);
        this._potentialEnergyLegendLine.setStroke(ENERGY_LINE_STROKE);
        this._legend.addChild(this._potentialEnergyLegendLine);
        this._potentialEnergyLabel = new PText(NuclearPhysicsStrings.POTENTIAL_PROFILE_POTENTIAL_ENERGY);
        this._potentialEnergyLabel.setFont(new PhetFont(0, 14));
        this._legend.addChild(this._potentialEnergyLabel);
        this._totalEnergyLegendLine = new PLine();
        this._totalEnergyLegendLine.setStrokePaint(TOTAL_ENERGY_LINE_COLOR);
        this._totalEnergyLegendLine.setStroke(ENERGY_LINE_STROKE);
        this._legend.addChild(this._totalEnergyLegendLine);
        this._totalEnergyLabel = new PText(NuclearPhysicsStrings.POTENTIAL_PROFILE_TOTAL_ENERGY);
        this._totalEnergyLabel.setFont(new PhetFont(0, 14));
        this._legend.addChild(this._totalEnergyLabel);
        this._unfissionedNucleusImage = NuclearPhysicsResources.getImageNode("uranium-nucleus-small.png");
        this._unfissionedNucleusImage.setScale(0.15);
        this.addChild(this._unfissionedNucleusImage);
        this._largerDaughterNucleusImage = NuclearPhysicsResources.getImageNode("larger-daughter-nucleus.png");
        this._largerDaughterNucleusImage.setScale(0.15);
        this._largerDaughterNucleusImage.setVisible(false);
        this.addChild(this._largerDaughterNucleusImage);
        this._smallerDaughterNucleusImage = NuclearPhysicsResources.getImageNode("smaller-daughter-nucleus.png");
        this._smallerDaughterNucleusImage.setScale(0.15);
        this._smallerDaughterNucleusImage.setVisible(false);
        this.addChild(this._smallerDaughterNucleusImage);
    }

    private void updateBounds(double d, double d2) {
        this._usableAreaOriginX = 8.0;
        this._usableAreaOriginY = d2 - d2 * 0.5 + 8.0;
        this._usableWidth = d - 16.0;
        this._usableHeight = d2 * 0.5 - 16.0;
        this._graphOriginX = this._usableWidth * 0.1 + this._usableAreaOriginX;
        this._graphOriginY = this._usableHeight * 0.85 + this._usableAreaOriginY;
        double d3 = this._model.getAtomicNucleus().getDiameter();
        PDimension pDimension = new PDimension(d3, d3);
        this._canvas.getPhetRootNode().worldToScreen(pDimension);
        this._energyWellWidth = pDimension.getWidth();
        this._borderNode.setPathTo(new RoundRectangle2D.Double(this._usableAreaOriginX, this._usableAreaOriginY, this._usableWidth, this._usableHeight, 20.0, 20.0));
        Point2D.Double double_ = new Point2D.Double(this._usableAreaOriginX + 8.0, this._graphOriginY);
        Point2D.Double double_2 = new Point2D.Double(this._usableAreaOriginX + this._usableWidth - 8.0, this._graphOriginY);
        this._xAxisOfGraph.setTipAndTailLocations(double_, double_2);
        Point2D.Double double_3 = new Point2D.Double(this._graphOriginX, this._usableAreaOriginY + 8.0);
        Point2D.Double double_4 = new Point2D.Double(this._graphOriginX, this._usableAreaOriginY + this._usableHeight - 8.0);
        this._yAxisOfGraph.setTipAndTailLocations(double_3, double_4);
        this._yAxisLabelLow.setOffset(this._graphOriginX - 1.5 * (double)this._yAxisLabelLow.getFont().getSize(), this._graphOriginY - 0.12 * (this._graphOriginY - this._usableAreaOriginY));
        this._yAxisLabelHigh.setOffset(this._yAxisLabelLow.getOffset().getX() - 1.0 * (double)this._yAxisLabelLow.getFont().getSize(), this._graphOriginY - 0.12 * (this._graphOriginY - this._usableAreaOriginY));
        this._xAxisLabel.setOffset(((Point2D)double_2).getX() - this._xAxisLabel.getWidth() - this._xAxisOfGraph.getHeadHeight() - 10.0, this._graphOriginY + 5.0);
        this._xAxisTickMark.setPathTo(new Line2D.Double(this._usableAreaOriginX / 2.0 + this._usableWidth / 2.0, this._graphOriginY, this._usableAreaOriginX / 2.0 + this._usableWidth / 2.0, this._graphOriginY - 5.0));
        this._xAxisTickMarkLabel.setOffset(this._usableAreaOriginX / 2.0 + this._usableWidth / 2.0 - this._xAxisTickMarkLabel.getWidth() / 2.0, this._graphOriginY + this._xAxisTickMarkLabel.getHeight() / 2.0);
        this._totalEnergyLine.removeAllPoints();
        this._totalEnergyLine.addPoint(0, this._usableAreaOriginX + 24.0, this._graphOriginY - this._usableHeight * 0.4);
        this._totalEnergyLine.addPoint(1, this._usableAreaOriginX + this._usableWidth - 24.0, this._graphOriginY - this._usableHeight * 0.4);
        this.drawPotentialEnergyWell();
        double d4 = this._usableWidth - 190.0 - 8.0;
        double d5 = this._graphOriginY - 65.0 - 0.18 * this._usableHeight;
        this._legend.setPathTo(new RoundRectangle2D.Double(d4, d5, 190.0, 65.0, 10.0, 10.0));
        this._potentialEnergyLegendLine.removeAllPoints();
        this._potentialEnergyLegendLine.addPoint(0, d4 + 15.0, d5 + 25.0);
        this._potentialEnergyLegendLine.addPoint(1, d4 + 40.0, d5 + 25.0);
        this._potentialEnergyLabel.setOffset(d4 + 50.0, d5 + 15.0);
        this._totalEnergyLegendLine.removeAllPoints();
        this._totalEnergyLegendLine.addPoint(0, d4 + 15.0, d5 + 45.0);
        this._totalEnergyLegendLine.addPoint(1, d4 + 40.0, d5 + 45.0);
        this._totalEnergyLabel.setOffset(d4 + 50.0, d5 + 35.0);
        this.updateNucleiPositions();
    }

    public void componentResized(double d, double d2) {
        this.updateBounds(d, d2);
    }

    private void drawPotentialEnergyWell() {
        this._potentialEnergyWell.reset();
        double d = this._usableAreaOriginX + 24.0;
        double d2 = this._usableAreaOriginX / 2.0 + this._usableWidth / 2.0;
        double d3 = this._usableAreaOriginX + this._usableWidth - 24.0;
        double d4 = d;
        double d5 = this._energyWellWidth * 80.0 / 2.0;
        double d6 = this._energyWellWidth * 0.6;
        double d7 = this._energyWellWidth / 4.0;
        double d8 = 1.0 / (d2 - d4) * d5;
        this._potentialEnergyWell.moveTo((float)d4, (float)this.convertGraphToScreenY(d8));
        d4 += 1.0;
        while (d4 < d3) {
            double d9;
            double d10 = d4 - d2;
            if (d4 < d2 - d6 - d7 / 2.0) {
                d8 = 1.0 / -d10 * d5;
                this._potentialEnergyWell.lineTo((float)d4, (float)this.convertGraphToScreenY(d8));
                d4 += 5.0;
                continue;
            }
            if (d4 < d2 - d6 + d7 / 2.0) {
                d9 = this.computeWellWeightingFactor(d2, d4, d6, d7);
                d8 = 1.0 / -d10 * d5 * (1.0 - d9) + this.calculateWellValue(d10) * d9;
                this._potentialEnergyWell.lineTo((float)d4, (float)this.convertGraphToScreenY(d8));
                d4 += 1.0;
                continue;
            }
            if (d4 < d2 + d6 - d7 / 2.0) {
                d8 = this.calculateWellValue(d10);
                this._potentialEnergyWell.lineTo((float)d4, (float)this.convertGraphToScreenY(d8));
                d4 += 1.0;
                continue;
            }
            if (d4 < d2 + d6 + d7 / 2.0) {
                d9 = this.computeWellWeightingFactor(d2, d4, d6, d7);
                d8 = 1.0 / d10 * d5 * (1.0 - d9) + this.calculateWellValue(d10) * d9;
                this._potentialEnergyWell.lineTo((float)d4, (float)this.convertGraphToScreenY(d8));
                d4 += 1.0;
                continue;
            }
            if (d4 < d3) {
                d8 = 1.0 / d10 * d5;
                this._potentialEnergyWell.lineTo((float)d4, (float)this.convertGraphToScreenY(d8));
                d4 += 5.0;
                continue;
            }
            d4 += 10.0;
        }
    }

    private double computeWellWeightingFactor(double d, double d2, double d3, double d4) {
        double d5 = 1.0 - (Math.abs(d - d2) - d3 + d4 / 2.0) / d4;
        return (-Math.cos(Math.PI * d5) + 1.0) / 2.0;
    }

    private double calculateWellValue(double d) {
        return 65.0 + (Math.cos((d * 2.0 / this._energyWellWidth - 1.0) * Math.PI) + 1.0) * 15.0 / 2.0;
    }

    private void updateNucleiPositions() {
        switch (this._fissionState) {
            case 0: {
                this._unfissionedNucleusImage.setVisible(true);
                double d = this._usableAreaOriginX / 2.0 + this._usableWidth / 2.0 - this._unfissionedNucleusImage.getFullBounds().width / 2.0;
                double d2 = this.convertGraphToScreenY(65.0) - this._unfissionedNucleusImage.getFullBounds().height / 2.0;
                this._unfissionedNucleusImage.setOffset(d, d2);
                this._totalEnergyLine.removeAllPoints();
                this._totalEnergyLine.addPoint(0, this._usableAreaOriginX + 24.0, d2 + this._unfissionedNucleusImage.getFullBounds().height / 2.0);
                this._totalEnergyLine.addPoint(1, this._usableAreaOriginX + this._usableWidth - 24.0, d2 + this._unfissionedNucleusImage.getFullBounds().height / 2.0);
                break;
            }
            case 1: {
                double d;
                double d3 = this._usableAreaOriginX / 2.0 + this._usableWidth / 2.0 - this._unfissionedNucleusImage.getFullBounds().width / 2.0;
                double d4 = this.convertGraphToScreenY(65.0);
                double d5 = this.convertGraphToScreenY(80.0) - this._unfissionedNucleusImage.getFullBoundsReference().height / 2.0;
                if (this._unfissionedNucleusImage.getOffset().getY() > d5) {
                    d = this._unfissionedNucleusImage.getOffset().getY() + (d5 - d4) / 5.0;
                    if (d < d5) {
                        d = d5;
                    }
                } else {
                    d = d5;
                }
                d3 += d3 * (this._rand.nextDouble() - 0.5) * 0.1;
                this._unfissionedNucleusImage.setOffset(d3, d);
                this._totalEnergyLine.removeAllPoints();
                this._totalEnergyLine.addPoint(0, this._usableAreaOriginX + 24.0, d + this._unfissionedNucleusImage.getFullBounds().height / 2.0);
                this._totalEnergyLine.addPoint(1, this._usableAreaOriginX + this._usableWidth - 24.0, d + this._unfissionedNucleusImage.getFullBounds().height / 2.0);
                break;
            }
            case 2: {
                double d = this.convertGraphToScreenY(80.0);
                Point2D point2D = this._model.getAtomicNucleus().getPositionReference();
                PDimension pDimension = new PDimension(point2D.getX(), point2D.getX());
                this._canvas.getPhetRootNode().worldToScreen(pDimension);
                double d6 = this._usableAreaOriginX / 2.0 + this._usableWidth / 2.0 + pDimension.getWidth();
                if (d6 < this._usableAreaOriginX + this._usableWidth && d6 > this._usableAreaOriginX) {
                    this._largerDaughterNucleusImage.setOffset(d6 - this._largerDaughterNucleusImage.getFullBounds().width / 2.0, d - this._largerDaughterNucleusImage.getFullBounds().height / 2.0);
                } else {
                    this._largerDaughterNucleusImage.setVisible(false);
                }
                if (this._daughterNucleus != null) {
                    point2D = this._daughterNucleus.getPositionReference();
                    pDimension = new PDimension(point2D.getX(), point2D.getX());
                    this._canvas.getPhetRootNode().worldToScreen(pDimension);
                    d6 = this._usableAreaOriginX / 2.0 + this._usableWidth / 2.0 + pDimension.getWidth();
                    if (d6 < this._usableAreaOriginX + this._usableWidth && d6 > this._usableAreaOriginX) {
                        this._smallerDaughterNucleusImage.setOffset(d6 - this._largerDaughterNucleusImage.getFullBounds().width / 2.0, d - this._largerDaughterNucleusImage.getFullBounds().height / 2.0);
                    } else {
                        this._smallerDaughterNucleusImage.setVisible(false);
                    }
                }
                this._totalEnergyLine.removeAllPoints();
                this._totalEnergyLine.addPoint(0, this._usableAreaOriginX + 24.0, this.convertGraphToScreenY(80.0));
                this._totalEnergyLine.addPoint(1, this._usableAreaOriginX + this._usableWidth - 24.0, this.convertGraphToScreenY(80.0));
            }
        }
    }

    private void handleClockTicked(ClockEvent clockEvent) {
        if (this._fissionState == 1 || this._fissionState == 2) {
            this.updateNucleiPositions();
        }
    }

    private double convertGraphToScreenY(double d) {
        return this._graphOriginY - d * ((this._graphOriginY - this._usableAreaOriginY) / 100.0);
    }
}

