/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.radioactivedatinggame;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.nuclearphysics.common.NuclearPhysicsClock;
import edu.colorado.phet.nuclearphysics.model.HalfLifeInfo;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.AgingRock;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.AgingTree;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.AnimatedDatableItem;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.AnimatedFlyingRock;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.DatableItem;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.EruptingVolcano;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.ModelAnimationAdapter;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.ModelContainingDatableItems;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.RadiometricClosureState;
import edu.colorado.phet.nuclearphysics.module.radioactivedatinggame.RadiometricDatingMeter;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;

public class RadiometricMeasurementModel
implements ModelContainingDatableItems {
    private SIMULATION_MODE DEFAULT_MODE = SIMULATION_MODE.TREE;
    private static final Point2D INITIAL_TREE_POSITION = new Point2D.Double(0.0, -4.0);
    private static final Point2D INITIAL_VOLCANO_POSITION = new Point2D.Double(13.0, 1.0);
    private static final Point2D INITIAL_ROCK_POSITION = new Point2D.Double(13.0, 4.5);
    private static final Point2D INITIAL_PROBE_TIP_POSITION = new Point2D.Double(0.0, 10.0);
    private static final double INITIAL_TREE_AGING_RATE = HalfLifeInfo.convertYearsToMs(300.0) / 1000.0;
    private static final double INITIAL_ROCK_AGING_RATE = HalfLifeInfo.convertDaysToMs(90.0) / 10000.0;
    private static final double FINAL_ROCK_AGING_RATE = HalfLifeInfo.convertYearsToMs(1.0E9) / 5000.0;
    private static final Rectangle2D _rockBoundaryRect = new Rectangle2D.Double(-30.0, 0.0, 60.0, 25.0);
    private static final double TIME_ACC_INCREMENT = (FINAL_ROCK_AGING_RATE - INITIAL_ROCK_AGING_RATE) / (Math.pow(2.0, 50.0) - 1.0);
    private RadiometricDatingMeter _meter;
    private SIMULATION_MODE _simulationMode;
    private ConstantDtClock _clock;
    private ArrayList<Listener> _listeners = new ArrayList();
    private ArrayList<AnimatedDatableItem> _animatedModelElements = new ArrayList();
    private boolean _agingRockAdded = false;
    private AnimatedDatableItem.ClosureListener _closureListener;
    private RadiometricClosureState _closureState = RadiometricClosureState.CLOSURE_NOT_POSSIBLE;
    private int _timeAccelerationCount = 0;

    public RadiometricMeasurementModel(NuclearPhysicsClock nuclearPhysicsClock) {
        this._clock = nuclearPhysicsClock;
        this._clock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                RadiometricMeasurementModel.this.handleClockTicked();
            }
        });
        this._meter = new RadiometricDatingMeter(this, INITIAL_PROBE_TIP_POSITION, true);
        this._meter.getProbeModel().addObserver(new SimpleObserver(){

            public void update() {
                RadiometricMeasurementModel.this.getDatableItemAtLocation(RadiometricMeasurementModel.this._meter.getProbeModel().getTipLocation());
            }
        });
        this._closureListener = new AnimatedDatableItem.ClosureListener(){

            public void closureStateChanged(AnimatedDatableItem animatedDatableItem) {
                RadiometricMeasurementModel.this.handleClosureStateChanged(animatedDatableItem);
            }
        };
        this.setSimulationMode(this.DEFAULT_MODE);
    }

    protected void handleClosureStateChanged(AnimatedDatableItem animatedDatableItem) {
        if (this._closureState != animatedDatableItem.getClosureState()) {
            this._closureState = animatedDatableItem.getClosureState();
            this.notifyClosureStateChanged();
        }
        if (this._simulationMode == SIMULATION_MODE.ROCK && animatedDatableItem instanceof AgingRock && animatedDatableItem.getClosureState() == RadiometricClosureState.CLOSED) {
            this._timeAccelerationCount = 50;
        }
    }

    public RadiometricDatingMeter getMeter() {
        return this._meter;
    }

    public ArrayList getModelElements() {
        return new ArrayList<AnimatedDatableItem>(this._animatedModelElements);
    }

    public double getGroundLevelY() {
        return 0.0;
    }

    public SIMULATION_MODE getSimulationMode() {
        return this._simulationMode;
    }

    public void setSimulationMode(SIMULATION_MODE sIMULATION_MODE) {
        if (this._simulationMode != sIMULATION_MODE) {
            AnimatedDatableItem animatedDatableItem;
            this._simulationMode = sIMULATION_MODE;
            this._clock.stop();
            this._agingRockAdded = false;
            this._closureState = RadiometricClosureState.CLOSURE_NOT_POSSIBLE;
            this._timeAccelerationCount = 0;
            Iterator<AnimatedDatableItem> iterator = this._animatedModelElements.iterator();
            while (iterator.hasNext()) {
                animatedDatableItem = iterator.next();
                animatedDatableItem.removeClosureListener(this._closureListener);
                iterator.remove();
                this.notifyModelElementRemoved(animatedDatableItem);
            }
            this._clock.resetSimulationTime();
            switch (this._simulationMode) {
                case TREE: {
                    break;
                }
                case ROCK: {
                    animatedDatableItem = new EruptingVolcano(this._clock, INITIAL_VOLCANO_POSITION, 12.0, INITIAL_ROCK_AGING_RATE);
                    this._animatedModelElements.add(animatedDatableItem);
                    this.notifyModelElementAdded(animatedDatableItem);
                }
            }
            this.notifySimulationModeChanged();
        }
    }

    public void startOperation() {
        if (this._clock.getSimulationTime() != 0.0) {
            System.err.println(this.getClass().getName() + " - Warning: Command received to start operation when already started.");
            return;
        }
        switch (this._simulationMode) {
            case TREE: {
                this.plantTree();
                break;
            }
        }
        this._clock.start();
    }

    public void resetOperation() {
        SIMULATION_MODE sIMULATION_MODE = this._simulationMode;
        this._simulationMode = null;
        this.setSimulationMode(sIMULATION_MODE);
    }

    public double getAdjustedTime() {
        double d;
        block3: {
            block2: {
                d = this._clock.getSimulationTime();
                if (this._simulationMode != SIMULATION_MODE.TREE) break block2;
                for (AnimatedDatableItem animatedDatableItem : this._animatedModelElements) {
                    if (!(animatedDatableItem instanceof AgingTree)) continue;
                    d = animatedDatableItem.getTotalAge();
                }
                break block3;
            }
            if (this._simulationMode != SIMULATION_MODE.ROCK) break block3;
            for (AnimatedDatableItem animatedDatableItem : this._animatedModelElements) {
                if (!(animatedDatableItem instanceof EruptingVolcano)) continue;
                d = animatedDatableItem.getTotalAge();
            }
        }
        return d;
    }

    private void handleClockTicked() {
        if (this._simulationMode == SIMULATION_MODE.ROCK) {
            AnimatedDatableItem animatedDatableItem;
            if (this._clock.getSimulationTime() == 4000.0 && !this._agingRockAdded) {
                animatedDatableItem = new AgingRock(this._clock, INITIAL_ROCK_POSITION, 1.0, INITIAL_ROCK_AGING_RATE);
                this._animatedModelElements.add(animatedDatableItem);
                animatedDatableItem.addClosureListener(this._closureListener);
                this.notifyModelElementAdded(animatedDatableItem);
                this._agingRockAdded = true;
            } else if (this._clock.getSimulationTime() == 800.0 || this._clock.getSimulationTime() == 1200.0 || this._clock.getSimulationTime() == 1800.0 || this._clock.getSimulationTime() == 2000.0 || this._clock.getSimulationTime() == 3600.0 || this._clock.getSimulationTime() == 4800.0) {
                animatedDatableItem = new AnimatedFlyingRock(this._clock, INITIAL_ROCK_POSITION, 1.5, INITIAL_ROCK_AGING_RATE);
                this._animatedModelElements.add(animatedDatableItem);
                new FlyingRockManager(this, (AnimatedFlyingRock)animatedDatableItem);
                this.notifyModelElementAdded(animatedDatableItem);
            }
            if (this._timeAccelerationCount > 0) {
                double d = 50 - this._timeAccelerationCount;
                double d2 = this._animatedModelElements.get(0).getTimeConversionFactor();
                d2 = Math.min(d2 + Math.pow(2.0, d) * TIME_ACC_INCREMENT, FINAL_ROCK_AGING_RATE);
                for (AnimatedDatableItem animatedDatableItem2 : this._animatedModelElements) {
                    animatedDatableItem2.setTimeConversionFactor(d2);
                }
                --this._timeAccelerationCount;
            }
        }
    }

    private void plantTree() {
        assert (this._animatedModelElements.size() == 0);
        AgingTree agingTree = new AgingTree(this._clock, INITIAL_TREE_POSITION, 1.0, INITIAL_TREE_AGING_RATE);
        this._animatedModelElements.add(agingTree);
        agingTree.addClosureListener(this._closureListener);
        this.notifyModelElementAdded(agingTree);
    }

    public RadiometricClosureState getRadiometricClosureState() {
        return this._closureState;
    }

    public void forceClosure() {
        for (AnimatedDatableItem animatedDatableItem : this._animatedModelElements) {
            if (!(animatedDatableItem instanceof AgingRock) && !(animatedDatableItem instanceof AgingTree)) continue;
            animatedDatableItem.forceClosure();
        }
    }

    public ConstantDtClock getClock() {
        return this._clock;
    }

    public void addListener(Listener listener) {
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    public DatableItem getDatableItemAtLocation(Point2D point2D) {
        DatableItem datableItem = null;
        for (AnimatedDatableItem animatedDatableItem : this._animatedModelElements) {
            if (!(animatedDatableItem instanceof DatableItem) || !((DatableItem)animatedDatableItem).contains(point2D)) continue;
            datableItem = animatedDatableItem;
        }
        return datableItem;
    }

    public DatableItem getDatableAir() {
        return DatableItem.DATABLE_AIR;
    }

    protected void notifySimulationModeChanged() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).simulationModeChanged();
        }
    }

    protected void notifyModelElementAdded(Object object) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).modelElementAdded(object);
        }
    }

    protected void notifyModelElementRemoved(Object object) {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).modelElementRemoved(object);
        }
    }

    protected void notifyClosureStateChanged() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).closureStateChanged();
        }
    }

    public static class Adapter
    implements Listener {
        public void simulationModeChanged() {
        }

        public void modelElementAdded(Object object) {
        }

        public void modelElementRemoved(Object object) {
        }

        public void closureStateChanged() {
        }
    }

    public static class FlyingRockManager {
        private final AnimatedFlyingRock _rock;
        private final RadiometricMeasurementModel _model;
        private final ModelAnimationAdapter _animationListener;

        public FlyingRockManager(RadiometricMeasurementModel radiometricMeasurementModel, AnimatedFlyingRock animatedFlyingRock) {
            this._rock = animatedFlyingRock;
            this._model = radiometricMeasurementModel;
            this._animationListener = new ModelAnimationAdapter(){

                public void positionChanged() {
                    if (!_rockBoundaryRect.contains(FlyingRockManager.this._rock.getPosition())) {
                        FlyingRockManager.this._model._animatedModelElements.remove(FlyingRockManager.this._rock);
                        FlyingRockManager.this._model.notifyModelElementRemoved(FlyingRockManager.this._rock);
                        FlyingRockManager.this._rock.removeAnimationListener(FlyingRockManager.this._animationListener);
                    }
                }
            };
            animatedFlyingRock.addAnimationListener(this._animationListener);
        }
    }

    public static interface Listener {
        public void simulationModeChanged();

        public void modelElementAdded(Object var1);

        public void modelElementRemoved(Object var1);

        public void closureStateChanged();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SIMULATION_MODE
    extends Enum<SIMULATION_MODE> {
        public static final /* enum */ SIMULATION_MODE TREE = new SIMULATION_MODE();
        public static final /* enum */ SIMULATION_MODE ROCK = new SIMULATION_MODE();
        private static final /* synthetic */ SIMULATION_MODE[] $VALUES;

        public static SIMULATION_MODE[] values() {
            return (SIMULATION_MODE[])$VALUES.clone();
        }

        static {
            $VALUES = new SIMULATION_MODE[]{TREE, ROCK};
        }
    }
}

