/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.halflife;

import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.common.NuclearPhysicsClock;
import edu.colorado.phet.nuclearphysics.module.halflife.IsotopeSelectionControlPanel;
import edu.colorado.phet.nuclearphysics.module.halflife.RadiometricElementDecayCanvas;
import edu.colorado.phet.nuclearphysics.module.halflife.RadiometricElementDecayModel;
import java.awt.Frame;

public class RadiometricElementDecayModule
extends PiccoloModule {
    private RadiometricElementDecayModel _model;
    private RadiometricElementDecayCanvas _canvas;
    private IsotopeSelectionControlPanel _controlPanel;

    public RadiometricElementDecayModule(Frame frame) {
        super(NuclearPhysicsStrings.TITLE_RADIOMETRIC_ELEMENT_HALF_LIFE, new NuclearPhysicsClock(25, 40.0));
        NuclearPhysicsClock nuclearPhysicsClock = (NuclearPhysicsClock)this.getClock();
        this._model = new RadiometricElementDecayModel(nuclearPhysicsClock);
        this._canvas = new RadiometricElementDecayCanvas(this._model);
        this.setSimulationPanel(this._canvas);
        this._controlPanel = new IsotopeSelectionControlPanel(this, frame, this._model, true);
        this.setControlPanel(this._controlPanel);
        if (this.hasHelp()) {
            // empty if block
        }
        this.reset();
    }

    public void reset() {
        this._model.getClock().resetSimulationTime();
        this._model.reset();
        this.setClockRunningWhenActive(true);
        this._canvas.reset();
    }
}

