/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.nuclearphysics.module.alphadecay;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.ArrowNode;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsConstants;
import edu.colorado.phet.nuclearphysics.NuclearPhysicsStrings;
import edu.colorado.phet.nuclearphysics.common.NucleusType;
import edu.colorado.phet.nuclearphysics.common.model.NucleusTypeControl;
import edu.colorado.phet.nuclearphysics.model.NuclearDecayListenerAdapter;
import edu.colorado.phet.nuclearphysics.view.LabeledNucleusImageNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;

public class AlphaDecayNucleusSelectionPanel
extends JPanel {
    private NucleusTypeControl _alphaDecayModel;
    private JRadioButton _poloniumRadioButton;
    private JRadioButton _customNucleusRadioButton;

    public AlphaDecayNucleusSelectionPanel(NucleusTypeControl nucleusTypeControl) {
        this._alphaDecayModel = nucleusTypeControl;
        nucleusTypeControl.addListener(new NuclearDecayListenerAdapter(){

            public void nucleusTypeChanged() {
                if (AlphaDecayNucleusSelectionPanel.this._alphaDecayModel.getNucleusType() == NucleusType.HEAVY_CUSTOM) {
                    AlphaDecayNucleusSelectionPanel.this._customNucleusRadioButton.setSelected(true);
                } else {
                    AlphaDecayNucleusSelectionPanel.this._poloniumRadioButton.setSelected(true);
                }
            }
        });
        BevelBorder bevelBorder = (BevelBorder)BorderFactory.createRaisedBevelBorder();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(bevelBorder, NuclearPhysicsStrings.NUCLEUS_SELECTION_BORDER_LABEL, 1, 2, new PhetFont(1, 14), Color.GRAY);
        this.setBorder(titledBorder);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this._poloniumRadioButton = new JRadioButton();
        this._customNucleusRadioButton = new JRadioButton();
        this._poloniumRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlphaDecayNucleusSelectionPanel.this._alphaDecayModel.setNucleusType(NucleusType.POLONIUM_211);
            }
        });
        this._customNucleusRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlphaDecayNucleusSelectionPanel.this._alphaDecayModel.setNucleusType(NucleusType.HEAVY_CUSTOM);
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._poloniumRadioButton);
        buttonGroup.add(this._customNucleusRadioButton);
        this._poloniumRadioButton.setSelected(true);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 25;
        this.add((Component)this._poloniumRadioButton, gridBagConstraints);
        gridBagConstraints.ipadx = 0;
        LabeledNucleusImageNode labeledNucleusImageNode = new LabeledNucleusImageNode("polonium-nucleus-small.png", NuclearPhysicsStrings.POLONIUM_211_ISOTOPE_NUMBER, NuclearPhysicsStrings.POLONIUM_211_CHEMICAL_SYMBOL, NuclearPhysicsConstants.POLONIUM_LABEL_COLOR);
        Image image = labeledNucleusImageNode.toImage();
        ImageIcon imageIcon = new ImageIcon(image);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.add((Component)new JLabel(imageIcon), gridBagConstraints);
        JLabel jLabel = new JLabel(NuclearPhysicsStrings.POLONIUM_211_LEGEND_LABEL);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.add((Component)new JLabel(this.createArrowIcon(Color.BLACK)), gridBagConstraints);
        LabeledNucleusImageNode labeledNucleusImageNode2 = new LabeledNucleusImageNode("polonium-nucleus-small.png", NuclearPhysicsStrings.LEAD_207_ISOTOPE_NUMBER, NuclearPhysicsStrings.LEAD_207_CHEMICAL_SYMBOL, NuclearPhysicsConstants.LEAD_LABEL_COLOR);
        Image image2 = labeledNucleusImageNode2.toImage();
        ImageIcon imageIcon2 = new ImageIcon(image2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.add((Component)new JLabel(imageIcon2), gridBagConstraints);
        JLabel jLabel2 = new JLabel(NuclearPhysicsStrings.LEAD_207_LEGEND_LABEL);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.add((Component)this.createVerticalSpacingPanel(20), gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.add((Component)this._customNucleusRadioButton, gridBagConstraints);
        LabeledNucleusImageNode labeledNucleusImageNode3 = new LabeledNucleusImageNode("polonium-nucleus-small.png", "", NuclearPhysicsStrings.CUSTOM_NUCLEUS_CHEMICAL_SYMBOL, NuclearPhysicsConstants.CUSTOM_NUCLEUS_LABEL_COLOR);
        Image image3 = labeledNucleusImageNode3.toImage();
        ImageIcon imageIcon3 = new ImageIcon(image3);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        this.add((Component)new JLabel(imageIcon3), gridBagConstraints);
        JLabel jLabel3 = new JLabel(NuclearPhysicsStrings.CUSTOM_NUCLEUS_LEGEND_LABEL);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        this.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        this.add((Component)new JLabel(this.createArrowIcon(Color.BLACK)), gridBagConstraints);
        LabeledNucleusImageNode labeledNucleusImageNode4 = new LabeledNucleusImageNode("polonium-nucleus-small.png", "", NuclearPhysicsStrings.CUSTOM_NUCLEUS_CHEMICAL_SYMBOL, NuclearPhysicsConstants.CUSTOM_NUCLEUS_POST_DECAY_LABEL_COLOR);
        Image image4 = labeledNucleusImageNode4.toImage();
        ImageIcon imageIcon4 = new ImageIcon(image4);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        this.add((Component)new JLabel(imageIcon4), gridBagConstraints);
        JLabel jLabel4 = new JLabel(NuclearPhysicsStrings.DECAYED_CUSTOM_NUCLEUS_LEGEND_LABEL);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        this.add((Component)jLabel4, gridBagConstraints);
    }

    private ImageIcon createArrowIcon(Color color) {
        ArrowNode arrowNode = new ArrowNode(new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 15.0), 8.0, 14.0, 6.0);
        arrowNode.setPaint(color);
        Image image = arrowNode.toImage();
        return new ImageIcon(image);
    }

    private JPanel createVerticalSpacingPanel(int n) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createVerticalStrut(n));
        return jPanel;
    }
}

